/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.security.models;

import com.clerk.backend_api.helpers.security.models.APIKeyMachineAuthObject;
import com.clerk.backend_api.helpers.security.models.AuthErrorReason;
import com.clerk.backend_api.helpers.security.models.AuthObject;
import com.clerk.backend_api.helpers.security.models.AuthStatus;
import com.clerk.backend_api.helpers.security.models.ErrorReason;
import com.clerk.backend_api.helpers.security.models.M2MMachineAuthObject;
import com.clerk.backend_api.helpers.security.models.MachineAuthVerificationData;
import com.clerk.backend_api.helpers.security.models.OAuthMachineAuthObject;
import com.clerk.backend_api.helpers.security.models.SessionAuthObjectV1;
import com.clerk.backend_api.helpers.security.models.SessionAuthObjectV2;
import com.clerk.backend_api.helpers.security.models.TokenType;
import com.clerk.backend_api.helpers.security.models.TokenVerificationErrorReason;
import com.clerk.backend_api.helpers.security.models.TokenVerificationResponse;
import com.clerk.backend_api.helpers.security.util.TokenTypeHelper;
import com.clerk.backend_api.utils.Utils;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class RequestState {
    private final AuthStatus status;
    private final Optional<AuthErrorReason> authErrorReason;
    private final Optional<TokenVerificationErrorReason> tokenVerificationErrorReason;
    private final Optional<String> token;
    private final Optional<TokenVerificationResponse<?>> tokenVerificationResponse;

    public RequestState(AuthStatus status, Optional<AuthErrorReason> authErrorReason, Optional<TokenVerificationErrorReason> tokenVerificationErrorReason, Optional<String> token, Optional<TokenVerificationResponse<?>> tokenVerificationResponse) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(authErrorReason, "authErrorReason");
        Utils.checkNotNull(tokenVerificationErrorReason, "tokenVerificationErrorReason");
        Utils.checkNotNull(token, "token");
        if (authErrorReason.isPresent() && tokenVerificationErrorReason.isPresent()) {
            throw new IllegalArgumentException("Only one of authErrorReason or tokenVerificationErrorReason should be provided.");
        }
        this.status = status;
        this.authErrorReason = authErrorReason;
        this.tokenVerificationErrorReason = tokenVerificationErrorReason;
        this.token = token;
        this.tokenVerificationResponse = tokenVerificationResponse;
    }

    public static RequestState signedIn(String token, TokenVerificationResponse<?> tokenVerificationResponse) {
        return new RequestState(AuthStatus.SIGNED_IN, Optional.empty(), Optional.empty(), Optional.of(token), Optional.of(tokenVerificationResponse));
    }

    public static RequestState signedOut(AuthErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.of(reason), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static RequestState signedOut(TokenVerificationErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.empty(), Optional.of(reason), Optional.empty(), Optional.empty());
    }

    public AuthStatus status() {
        return this.status;
    }

    public boolean isSignedIn() {
        return this.status == AuthStatus.SIGNED_IN;
    }

    public boolean isAuthenticated() {
        return this.isSignedIn();
    }

    public boolean isSignedOut() {
        return this.status == AuthStatus.SIGNED_OUT;
    }

    public Optional<ErrorReason> reason() {
        if (this.authErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.authErrorReason.get());
        }
        if (this.tokenVerificationErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.tokenVerificationErrorReason.get());
        }
        return Optional.empty();
    }

    public Optional<String> token() {
        return this.token;
    }

    public Optional<Claims> claims() {
        TokenVerificationResponse<?> response;
        if (this.tokenVerificationResponse.isPresent() && (response = this.tokenVerificationResponse.get()).payload() instanceof Claims) {
            return Optional.of((Claims)response.payload());
        }
        return Optional.empty();
    }

    public Optional<TokenVerificationResponse<?>> tokenVerificationResponse() {
        return this.tokenVerificationResponse;
    }

    public AuthObject toAuth() {
        if (this.status != AuthStatus.SIGNED_IN) {
            throw new IllegalStateException("Cannot convert to AuthObject in unauthenticated state.");
        }
        if (this.tokenVerificationResponse.isEmpty()) {
            throw new IllegalArgumentException("Payload must be provided for authenticated states.");
        }
        TokenType tokenType = TokenTypeHelper.getTokenType(this.token.get());
        switch (tokenType) {
            case SESSION_TOKEN: {
                HashMap<String, Object> payload = new HashMap<String, Object>((Map)this.tokenVerificationResponse.get().payload());
                Integer version = payload.getOrDefault("v", null);
                if (version != null && version == 2) {
                    return new SessionAuthObjectV2(payload.getOrDefault("exp", null), payload.getOrDefault("iat", null), payload.getOrDefault("iss", null), payload.getOrDefault("sid", null), payload.getOrDefault("sub", null), version, payload.getOrDefault("jti", null), payload.getOrDefault("role", null), payload.getOrDefault("fva", null), payload.getOrDefault("nbf", null), payload.getOrDefault("email", null), payload.getOrDefault("azp", null));
                }
                return new SessionAuthObjectV1(payload.getOrDefault("sid", null), payload.getOrDefault("sub", null), payload.getOrDefault("org_id", null), payload.getOrDefault("org_role", null), payload.getOrDefault("org_permissions", null), payload.getOrDefault("fva", null), payload);
            }
            case OAUTH_TOKEN: {
                MachineAuthVerificationData oAuthData = (MachineAuthVerificationData)this.tokenVerificationResponse.get().payload();
                return new OAuthMachineAuthObject(oAuthData.getId(), oAuthData.getSubject(), oAuthData.getClientId(), oAuthData.getName(), oAuthData.getScopes());
            }
            case API_KEY: {
                MachineAuthVerificationData apiKeyData = (MachineAuthVerificationData)this.tokenVerificationResponse.get().payload();
                return new APIKeyMachineAuthObject(apiKeyData.getId(), apiKeyData.getSubject(), null, apiKeyData.getName(), apiKeyData.getScopes(), apiKeyData.getClaims());
            }
            case MACHINE_TOKEN: {
                MachineAuthVerificationData machineData = (MachineAuthVerificationData)this.tokenVerificationResponse.get().payload();
                return new M2MMachineAuthObject(machineData.getId(), machineData.getSubject(), machineData.getClientId(), machineData.getName(), machineData.getScopes(), machineData.getClaims());
            }
        }
        throw new IllegalArgumentException("Unsupported token type: " + String.valueOf((Object)tokenType));
    }
}

