/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Object;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class AWSCredential {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private Object object;
    @JsonProperty(value="access_key_id")
    private String accessKeyId;
    @JsonProperty(value="user_pool_ids")
    private List<String> userPoolIds;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public AWSCredential(@JsonProperty(value="id") String id, @JsonProperty(value="object") Object object, @JsonProperty(value="access_key_id") String accessKeyId, @JsonProperty(value="user_pool_ids") List<String> userPoolIds, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(accessKeyId, "accessKeyId");
        Utils.checkNotNull(userPoolIds, "userPoolIds");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.object = object;
        this.accessKeyId = accessKeyId;
        this.userPoolIds = userPoolIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Object object() {
        return this.object;
    }

    @JsonIgnore
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @JsonIgnore
    public List<String> userPoolIds() {
        return this.userPoolIds;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AWSCredential withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AWSCredential withObject(Object object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public AWSCredential withAccessKeyId(String accessKeyId) {
        Utils.checkNotNull(accessKeyId, "accessKeyId");
        this.accessKeyId = accessKeyId;
        return this;
    }

    public AWSCredential withUserPoolIds(List<String> userPoolIds) {
        Utils.checkNotNull(userPoolIds, "userPoolIds");
        this.userPoolIds = userPoolIds;
        return this;
    }

    public AWSCredential withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public AWSCredential withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSCredential other = (AWSCredential)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals((java.lang.Object)this.object, (java.lang.Object)other.object) && Utils.enhancedDeepEquals(this.accessKeyId, other.accessKeyId) && Utils.enhancedDeepEquals(this.userPoolIds, other.userPoolIds) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new java.lang.Object[]{this.id, this.object, this.accessKeyId, this.userPoolIds, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(AWSCredential.class, new java.lang.Object[]{"id", this.id, "object", this.object, "accessKeyId", this.accessKeyId, "userPoolIds", this.userPoolIds, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private String id;
        private Object object;
        private String accessKeyId;
        private List<String> userPoolIds;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(Object object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder accessKeyId(String accessKeyId) {
            Utils.checkNotNull(accessKeyId, "accessKeyId");
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder userPoolIds(List<String> userPoolIds) {
            Utils.checkNotNull(userPoolIds, "userPoolIds");
            this.userPoolIds = userPoolIds;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public AWSCredential build() {
            return new AWSCredential(this.id, this.object, this.accessKeyId, this.userPoolIds, this.createdAt, this.updatedAt);
        }
    }
}

