/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.BlocklistIdentifierIdentifierType;
import com.clerk.backend_api.models.components.BlocklistIdentifierObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class BlocklistIdentifier {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends BlocklistIdentifierObject> object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="identifier")
    private Optional<String> identifier;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="identifier_type")
    private Optional<? extends BlocklistIdentifierIdentifierType> identifierType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="instance_id")
    private Optional<String> instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="created_at")
    private Optional<Long> createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="updated_at")
    private Optional<Long> updatedAt;

    @JsonCreator
    public BlocklistIdentifier(@JsonProperty(value="object") Optional<? extends BlocklistIdentifierObject> object, @JsonProperty(value="id") Optional<String> id, @JsonProperty(value="identifier") Optional<String> identifier, @JsonProperty(value="identifier_type") Optional<? extends BlocklistIdentifierIdentifierType> identifierType, @JsonProperty(value="instance_id") Optional<String> instanceId, @JsonProperty(value="created_at") Optional<Long> createdAt, @JsonProperty(value="updated_at") Optional<Long> updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(identifier, "identifier");
        Utils.checkNotNull(identifierType, "identifierType");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.identifier = identifier;
        this.identifierType = identifierType;
        this.instanceId = instanceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public BlocklistIdentifier() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<BlocklistIdentifierObject> object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> identifier() {
        return this.identifier;
    }

    @JsonIgnore
    public Optional<BlocklistIdentifierIdentifierType> identifierType() {
        return this.identifierType;
    }

    @JsonIgnore
    public Optional<String> instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public Optional<Long> createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<Long> updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BlocklistIdentifier withObject(BlocklistIdentifierObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public BlocklistIdentifier withObject(Optional<? extends BlocklistIdentifierObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public BlocklistIdentifier withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public BlocklistIdentifier withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public BlocklistIdentifier withIdentifier(String identifier) {
        Utils.checkNotNull(identifier, "identifier");
        this.identifier = Optional.ofNullable(identifier);
        return this;
    }

    public BlocklistIdentifier withIdentifier(Optional<String> identifier) {
        Utils.checkNotNull(identifier, "identifier");
        this.identifier = identifier;
        return this;
    }

    public BlocklistIdentifier withIdentifierType(BlocklistIdentifierIdentifierType identifierType) {
        Utils.checkNotNull(identifierType, "identifierType");
        this.identifierType = Optional.ofNullable(identifierType);
        return this;
    }

    public BlocklistIdentifier withIdentifierType(Optional<? extends BlocklistIdentifierIdentifierType> identifierType) {
        Utils.checkNotNull(identifierType, "identifierType");
        this.identifierType = identifierType;
        return this;
    }

    public BlocklistIdentifier withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = Optional.ofNullable(instanceId);
        return this;
    }

    public BlocklistIdentifier withInstanceId(Optional<String> instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public BlocklistIdentifier withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = Optional.ofNullable(createdAt);
        return this;
    }

    public BlocklistIdentifier withCreatedAt(Optional<Long> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public BlocklistIdentifier withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = Optional.ofNullable(updatedAt);
        return this;
    }

    public BlocklistIdentifier withUpdatedAt(Optional<Long> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlocklistIdentifier other = (BlocklistIdentifier)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.identifier, other.identifier) && Utils.enhancedDeepEquals(this.identifierType, other.identifierType) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.object, this.id, this.identifier, this.identifierType, this.instanceId, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return Utils.toString(BlocklistIdentifier.class, "object", this.object, "id", this.id, "identifier", this.identifier, "identifierType", this.identifierType, "instanceId", this.instanceId, "createdAt", this.createdAt, "updatedAt", this.updatedAt);
    }

    public static final class Builder {
        private Optional<? extends BlocklistIdentifierObject> object = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> identifier = Optional.empty();
        private Optional<? extends BlocklistIdentifierIdentifierType> identifierType = Optional.empty();
        private Optional<String> instanceId = Optional.empty();
        private Optional<Long> createdAt = Optional.empty();
        private Optional<Long> updatedAt = Optional.empty();

        private Builder() {
        }

        public Builder object(BlocklistIdentifierObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends BlocklistIdentifierObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder identifier(String identifier) {
            Utils.checkNotNull(identifier, "identifier");
            this.identifier = Optional.ofNullable(identifier);
            return this;
        }

        public Builder identifier(Optional<String> identifier) {
            Utils.checkNotNull(identifier, "identifier");
            this.identifier = identifier;
            return this;
        }

        public Builder identifierType(BlocklistIdentifierIdentifierType identifierType) {
            Utils.checkNotNull(identifierType, "identifierType");
            this.identifierType = Optional.ofNullable(identifierType);
            return this;
        }

        public Builder identifierType(Optional<? extends BlocklistIdentifierIdentifierType> identifierType) {
            Utils.checkNotNull(identifierType, "identifierType");
            this.identifierType = identifierType;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = Optional.ofNullable(instanceId);
            return this;
        }

        public Builder instanceId(Optional<String> instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public Builder createdAt(Optional<Long> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Builder updatedAt(Optional<Long> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public BlocklistIdentifier build() {
            return new BlocklistIdentifier(this.object, this.id, this.identifier, this.identifierType, this.instanceId, this.createdAt, this.updatedAt);
        }
    }
}

