/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CommerceMoneyResponse {
    @JsonProperty(value="amount")
    private long amount;
    @JsonProperty(value="amount_formatted")
    private String amountFormatted;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="currency_symbol")
    private String currencySymbol;

    @JsonCreator
    public CommerceMoneyResponse(@JsonProperty(value="amount") long amount, @JsonProperty(value="amount_formatted") String amountFormatted, @JsonProperty(value="currency") String currency, @JsonProperty(value="currency_symbol") String currencySymbol) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(amountFormatted, "amountFormatted");
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(currencySymbol, "currencySymbol");
        this.amount = amount;
        this.amountFormatted = amountFormatted;
        this.currency = currency;
        this.currencySymbol = currencySymbol;
    }

    @JsonIgnore
    public long amount() {
        return this.amount;
    }

    @JsonIgnore
    public String amountFormatted() {
        return this.amountFormatted;
    }

    @JsonIgnore
    public String currency() {
        return this.currency;
    }

    @JsonIgnore
    public String currencySymbol() {
        return this.currencySymbol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommerceMoneyResponse withAmount(long amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public CommerceMoneyResponse withAmountFormatted(String amountFormatted) {
        Utils.checkNotNull(amountFormatted, "amountFormatted");
        this.amountFormatted = amountFormatted;
        return this;
    }

    public CommerceMoneyResponse withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    public CommerceMoneyResponse withCurrencySymbol(String currencySymbol) {
        Utils.checkNotNull(currencySymbol, "currencySymbol");
        this.currencySymbol = currencySymbol;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommerceMoneyResponse other = (CommerceMoneyResponse)o;
        return Utils.enhancedDeepEquals(this.amount, other.amount) && Utils.enhancedDeepEquals(this.amountFormatted, other.amountFormatted) && Utils.enhancedDeepEquals(this.currency, other.currency) && Utils.enhancedDeepEquals(this.currencySymbol, other.currencySymbol);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.amount, this.amountFormatted, this.currency, this.currencySymbol);
    }

    public String toString() {
        return Utils.toString(CommerceMoneyResponse.class, "amount", this.amount, "amountFormatted", this.amountFormatted, "currency", this.currency, "currencySymbol", this.currencySymbol);
    }

    public static final class Builder {
        private Long amount;
        private String amountFormatted;
        private String currency;
        private String currencySymbol;

        private Builder() {
        }

        public Builder amount(long amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder amountFormatted(String amountFormatted) {
            Utils.checkNotNull(amountFormatted, "amountFormatted");
            this.amountFormatted = amountFormatted;
            return this;
        }

        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }

        public Builder currencySymbol(String currencySymbol) {
            Utils.checkNotNull(currencySymbol, "currencySymbol");
            this.currencySymbol = currencySymbol;
            return this;
        }

        public CommerceMoneyResponse build() {
            return new CommerceMoneyResponse(this.amount, this.amountFormatted, this.currency, this.currencySymbol);
        }
    }
}

