/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceSubscriptionItem;
import com.clerk.backend_api.models.components.CommerceSubscriptionNextPayment;
import com.clerk.backend_api.models.components.CommerceSubscriptionObject;
import com.clerk.backend_api.models.components.CommerceSubscriptionStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class CommerceSubscription {
    @JsonProperty(value="object")
    private CommerceSubscriptionObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="status")
    private CommerceSubscriptionStatus status;
    @JsonProperty(value="payer_id")
    private String payerId;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="active_at")
    private JsonNullable<Long> activeAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="past_due_at")
    private JsonNullable<Long> pastDueAt;
    @JsonProperty(value="subscription_items")
    private List<CommerceSubscriptionItem> subscriptionItems;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="next_payment")
    private Optional<? extends CommerceSubscriptionNextPayment> nextPayment;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="eligible_for_free_trial")
    private JsonNullable<Boolean> eligibleForFreeTrial;

    @JsonCreator
    public CommerceSubscription(@JsonProperty(value="object") CommerceSubscriptionObject object, @JsonProperty(value="id") String id, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="status") CommerceSubscriptionStatus status, @JsonProperty(value="payer_id") String payerId, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="active_at") JsonNullable<Long> activeAt, @JsonProperty(value="past_due_at") JsonNullable<Long> pastDueAt, @JsonProperty(value="subscription_items") List<CommerceSubscriptionItem> subscriptionItems, @JsonProperty(value="next_payment") Optional<? extends CommerceSubscriptionNextPayment> nextPayment, @JsonProperty(value="eligible_for_free_trial") JsonNullable<Boolean> eligibleForFreeTrial) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(payerId, "payerId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(activeAt, "activeAt");
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        Utils.checkNotNull(subscriptionItems, "subscriptionItems");
        Utils.checkNotNull(nextPayment, "nextPayment");
        Utils.checkNotNull(eligibleForFreeTrial, "eligibleForFreeTrial");
        this.object = object;
        this.id = id;
        this.instanceId = instanceId;
        this.status = status;
        this.payerId = payerId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.activeAt = activeAt;
        this.pastDueAt = pastDueAt;
        this.subscriptionItems = subscriptionItems;
        this.nextPayment = nextPayment;
        this.eligibleForFreeTrial = eligibleForFreeTrial;
    }

    public CommerceSubscription(CommerceSubscriptionObject object, String id, String instanceId, CommerceSubscriptionStatus status, String payerId, long createdAt, long updatedAt, List<CommerceSubscriptionItem> subscriptionItems) {
        this(object, id, instanceId, status, payerId, createdAt, updatedAt, (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), subscriptionItems, Optional.empty(), (JsonNullable<Boolean>)JsonNullable.undefined());
    }

    @JsonIgnore
    public CommerceSubscriptionObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public CommerceSubscriptionStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String payerId() {
        return this.payerId;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public JsonNullable<Long> activeAt() {
        return this.activeAt;
    }

    @JsonIgnore
    public JsonNullable<Long> pastDueAt() {
        return this.pastDueAt;
    }

    @JsonIgnore
    public List<CommerceSubscriptionItem> subscriptionItems() {
        return this.subscriptionItems;
    }

    @JsonIgnore
    public Optional<CommerceSubscriptionNextPayment> nextPayment() {
        return this.nextPayment;
    }

    @JsonIgnore
    public JsonNullable<Boolean> eligibleForFreeTrial() {
        return this.eligibleForFreeTrial;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommerceSubscription withObject(CommerceSubscriptionObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public CommerceSubscription withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CommerceSubscription withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public CommerceSubscription withStatus(CommerceSubscriptionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public CommerceSubscription withPayerId(String payerId) {
        Utils.checkNotNull(payerId, "payerId");
        this.payerId = payerId;
        return this;
    }

    public CommerceSubscription withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public CommerceSubscription withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public CommerceSubscription withActiveAt(long activeAt) {
        Utils.checkNotNull(activeAt, "activeAt");
        this.activeAt = JsonNullable.of((Object)activeAt);
        return this;
    }

    public CommerceSubscription withActiveAt(JsonNullable<Long> activeAt) {
        Utils.checkNotNull(activeAt, "activeAt");
        this.activeAt = activeAt;
        return this;
    }

    public CommerceSubscription withPastDueAt(long pastDueAt) {
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        this.pastDueAt = JsonNullable.of((Object)pastDueAt);
        return this;
    }

    public CommerceSubscription withPastDueAt(JsonNullable<Long> pastDueAt) {
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        this.pastDueAt = pastDueAt;
        return this;
    }

    public CommerceSubscription withSubscriptionItems(List<CommerceSubscriptionItem> subscriptionItems) {
        Utils.checkNotNull(subscriptionItems, "subscriptionItems");
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    public CommerceSubscription withNextPayment(CommerceSubscriptionNextPayment nextPayment) {
        Utils.checkNotNull(nextPayment, "nextPayment");
        this.nextPayment = Optional.ofNullable(nextPayment);
        return this;
    }

    public CommerceSubscription withNextPayment(Optional<? extends CommerceSubscriptionNextPayment> nextPayment) {
        Utils.checkNotNull(nextPayment, "nextPayment");
        this.nextPayment = nextPayment;
        return this;
    }

    public CommerceSubscription withEligibleForFreeTrial(boolean eligibleForFreeTrial) {
        Utils.checkNotNull(eligibleForFreeTrial, "eligibleForFreeTrial");
        this.eligibleForFreeTrial = JsonNullable.of((Object)eligibleForFreeTrial);
        return this;
    }

    public CommerceSubscription withEligibleForFreeTrial(JsonNullable<Boolean> eligibleForFreeTrial) {
        Utils.checkNotNull(eligibleForFreeTrial, "eligibleForFreeTrial");
        this.eligibleForFreeTrial = eligibleForFreeTrial;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommerceSubscription other = (CommerceSubscription)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.payerId, other.payerId) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) && Utils.enhancedDeepEquals(this.activeAt, other.activeAt) && Utils.enhancedDeepEquals(this.pastDueAt, other.pastDueAt) && Utils.enhancedDeepEquals(this.subscriptionItems, other.subscriptionItems) && Utils.enhancedDeepEquals(this.nextPayment, other.nextPayment) && Utils.enhancedDeepEquals(this.eligibleForFreeTrial, other.eligibleForFreeTrial);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.instanceId, this.status, this.payerId, this.createdAt, this.updatedAt, this.activeAt, this.pastDueAt, this.subscriptionItems, this.nextPayment, this.eligibleForFreeTrial});
    }

    public String toString() {
        return Utils.toString(CommerceSubscription.class, new Object[]{"object", this.object, "id", this.id, "instanceId", this.instanceId, "status", this.status, "payerId", this.payerId, "createdAt", this.createdAt, "updatedAt", this.updatedAt, "activeAt", this.activeAt, "pastDueAt", this.pastDueAt, "subscriptionItems", this.subscriptionItems, "nextPayment", this.nextPayment, "eligibleForFreeTrial", this.eligibleForFreeTrial});
    }

    public static final class Builder {
        private CommerceSubscriptionObject object;
        private String id;
        private String instanceId;
        private CommerceSubscriptionStatus status;
        private String payerId;
        private Long createdAt;
        private Long updatedAt;
        private JsonNullable<Long> activeAt = JsonNullable.undefined();
        private JsonNullable<Long> pastDueAt = JsonNullable.undefined();
        private List<CommerceSubscriptionItem> subscriptionItems;
        private Optional<? extends CommerceSubscriptionNextPayment> nextPayment = Optional.empty();
        private JsonNullable<Boolean> eligibleForFreeTrial = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(CommerceSubscriptionObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder status(CommerceSubscriptionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder payerId(String payerId) {
            Utils.checkNotNull(payerId, "payerId");
            this.payerId = payerId;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder activeAt(long activeAt) {
            Utils.checkNotNull(activeAt, "activeAt");
            this.activeAt = JsonNullable.of((Object)activeAt);
            return this;
        }

        public Builder activeAt(JsonNullable<Long> activeAt) {
            Utils.checkNotNull(activeAt, "activeAt");
            this.activeAt = activeAt;
            return this;
        }

        public Builder pastDueAt(long pastDueAt) {
            Utils.checkNotNull(pastDueAt, "pastDueAt");
            this.pastDueAt = JsonNullable.of((Object)pastDueAt);
            return this;
        }

        public Builder pastDueAt(JsonNullable<Long> pastDueAt) {
            Utils.checkNotNull(pastDueAt, "pastDueAt");
            this.pastDueAt = pastDueAt;
            return this;
        }

        public Builder subscriptionItems(List<CommerceSubscriptionItem> subscriptionItems) {
            Utils.checkNotNull(subscriptionItems, "subscriptionItems");
            this.subscriptionItems = subscriptionItems;
            return this;
        }

        public Builder nextPayment(CommerceSubscriptionNextPayment nextPayment) {
            Utils.checkNotNull(nextPayment, "nextPayment");
            this.nextPayment = Optional.ofNullable(nextPayment);
            return this;
        }

        public Builder nextPayment(Optional<? extends CommerceSubscriptionNextPayment> nextPayment) {
            Utils.checkNotNull(nextPayment, "nextPayment");
            this.nextPayment = nextPayment;
            return this;
        }

        public Builder eligibleForFreeTrial(boolean eligibleForFreeTrial) {
            Utils.checkNotNull(eligibleForFreeTrial, "eligibleForFreeTrial");
            this.eligibleForFreeTrial = JsonNullable.of((Object)eligibleForFreeTrial);
            return this;
        }

        public Builder eligibleForFreeTrial(JsonNullable<Boolean> eligibleForFreeTrial) {
            Utils.checkNotNull(eligibleForFreeTrial, "eligibleForFreeTrial");
            this.eligibleForFreeTrial = eligibleForFreeTrial;
            return this;
        }

        public CommerceSubscription build() {
            return new CommerceSubscription(this.object, this.id, this.instanceId, this.status, this.payerId, this.createdAt, this.updatedAt, this.activeAt, this.pastDueAt, this.subscriptionItems, this.nextPayment, this.eligibleForFreeTrial);
        }
    }
}

