/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Amount;
import com.clerk.backend_api.models.components.CommerceSubscriptionItemObject;
import com.clerk.backend_api.models.components.CommerceSubscriptionItemStatus;
import com.clerk.backend_api.models.components.Credit;
import com.clerk.backend_api.models.components.LifetimePaid;
import com.clerk.backend_api.models.components.NextInvoice;
import com.clerk.backend_api.models.components.NextPayment;
import com.clerk.backend_api.models.components.Payer;
import com.clerk.backend_api.models.components.PaymentSource;
import com.clerk.backend_api.models.components.Plan;
import com.clerk.backend_api.models.components.PlanPeriod;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class CommerceSubscriptionItem {
    @JsonProperty(value="object")
    private CommerceSubscriptionItemObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="status")
    private CommerceSubscriptionItemStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="credit")
    private JsonNullable<? extends Credit> credit;
    @JsonProperty(value="plan_id")
    private String planId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="plan")
    private Optional<? extends Plan> plan;
    @JsonProperty(value="plan_period")
    private PlanPeriod planPeriod;
    @JsonProperty(value="payment_source_id")
    private String paymentSourceId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="payment_source")
    private JsonNullable<? extends PaymentSource> paymentSource;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="lifetime_paid")
    private JsonNullable<? extends LifetimePaid> lifetimePaid;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="amount")
    private JsonNullable<? extends Amount> amount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="next_invoice")
    private JsonNullable<? extends NextInvoice> nextInvoice;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="next_payment")
    private JsonNullable<? extends NextPayment> nextPayment;
    @JsonProperty(value="payer_id")
    private String payerId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="payer")
    private JsonNullable<? extends Payer> payer;
    @JsonProperty(value="is_free_trial")
    private boolean isFreeTrial;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="period_start")
    private JsonNullable<Long> periodStart;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="period_end")
    private JsonNullable<Long> periodEnd;
    @JsonProperty(value="proration_date")
    private String prorationDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="canceled_at")
    private JsonNullable<Long> canceledAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="past_due_at")
    private JsonNullable<Long> pastDueAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="ended_at")
    private JsonNullable<Long> endedAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public CommerceSubscriptionItem(@JsonProperty(value="object") CommerceSubscriptionItemObject object, @JsonProperty(value="id") String id, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="status") CommerceSubscriptionItemStatus status, @JsonProperty(value="credit") JsonNullable<? extends Credit> credit, @JsonProperty(value="plan_id") String planId, @JsonProperty(value="plan") Optional<? extends Plan> plan, @JsonProperty(value="plan_period") PlanPeriod planPeriod, @JsonProperty(value="payment_source_id") String paymentSourceId, @JsonProperty(value="payment_source") JsonNullable<? extends PaymentSource> paymentSource, @JsonProperty(value="lifetime_paid") JsonNullable<? extends LifetimePaid> lifetimePaid, @JsonProperty(value="amount") JsonNullable<? extends Amount> amount, @JsonProperty(value="next_invoice") JsonNullable<? extends NextInvoice> nextInvoice, @JsonProperty(value="next_payment") JsonNullable<? extends NextPayment> nextPayment, @JsonProperty(value="payer_id") String payerId, @JsonProperty(value="payer") JsonNullable<? extends Payer> payer, @JsonProperty(value="is_free_trial") boolean isFreeTrial, @JsonProperty(value="period_start") JsonNullable<Long> periodStart, @JsonProperty(value="period_end") JsonNullable<Long> periodEnd, @JsonProperty(value="proration_date") String prorationDate, @JsonProperty(value="canceled_at") JsonNullable<Long> canceledAt, @JsonProperty(value="past_due_at") JsonNullable<Long> pastDueAt, @JsonProperty(value="ended_at") JsonNullable<Long> endedAt, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(credit, "credit");
        Utils.checkNotNull(planId, "planId");
        Utils.checkNotNull(plan, "plan");
        Utils.checkNotNull(planPeriod, "planPeriod");
        Utils.checkNotNull(paymentSourceId, "paymentSourceId");
        Utils.checkNotNull(paymentSource, "paymentSource");
        Utils.checkNotNull(lifetimePaid, "lifetimePaid");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(nextInvoice, "nextInvoice");
        Utils.checkNotNull(nextPayment, "nextPayment");
        Utils.checkNotNull(payerId, "payerId");
        Utils.checkNotNull(payer, "payer");
        Utils.checkNotNull(isFreeTrial, "isFreeTrial");
        Utils.checkNotNull(periodStart, "periodStart");
        Utils.checkNotNull(periodEnd, "periodEnd");
        Utils.checkNotNull(prorationDate, "prorationDate");
        Utils.checkNotNull(canceledAt, "canceledAt");
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        Utils.checkNotNull(endedAt, "endedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.instanceId = instanceId;
        this.status = status;
        this.credit = credit;
        this.planId = planId;
        this.plan = plan;
        this.planPeriod = planPeriod;
        this.paymentSourceId = paymentSourceId;
        this.paymentSource = paymentSource;
        this.lifetimePaid = lifetimePaid;
        this.amount = amount;
        this.nextInvoice = nextInvoice;
        this.nextPayment = nextPayment;
        this.payerId = payerId;
        this.payer = payer;
        this.isFreeTrial = isFreeTrial;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.prorationDate = prorationDate;
        this.canceledAt = canceledAt;
        this.pastDueAt = pastDueAt;
        this.endedAt = endedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public CommerceSubscriptionItem(CommerceSubscriptionItemObject object, String id, String instanceId, CommerceSubscriptionItemStatus status, String planId, PlanPeriod planPeriod, String paymentSourceId, String payerId, boolean isFreeTrial, String prorationDate, long createdAt, long updatedAt) {
        this(object, id, instanceId, status, (JsonNullable<? extends Credit>)JsonNullable.undefined(), planId, Optional.empty(), planPeriod, paymentSourceId, (JsonNullable<? extends PaymentSource>)JsonNullable.undefined(), (JsonNullable<? extends LifetimePaid>)JsonNullable.undefined(), (JsonNullable<? extends Amount>)JsonNullable.undefined(), (JsonNullable<? extends NextInvoice>)JsonNullable.undefined(), (JsonNullable<? extends NextPayment>)JsonNullable.undefined(), payerId, (JsonNullable<? extends Payer>)JsonNullable.undefined(), isFreeTrial, (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), prorationDate, (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public CommerceSubscriptionItemObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public CommerceSubscriptionItemStatus status() {
        return this.status;
    }

    @JsonIgnore
    public JsonNullable<Credit> credit() {
        return this.credit;
    }

    @JsonIgnore
    public String planId() {
        return this.planId;
    }

    @JsonIgnore
    public Optional<Plan> plan() {
        return this.plan;
    }

    @JsonIgnore
    public PlanPeriod planPeriod() {
        return this.planPeriod;
    }

    @JsonIgnore
    public String paymentSourceId() {
        return this.paymentSourceId;
    }

    @JsonIgnore
    public JsonNullable<PaymentSource> paymentSource() {
        return this.paymentSource;
    }

    @JsonIgnore
    public JsonNullable<LifetimePaid> lifetimePaid() {
        return this.lifetimePaid;
    }

    @JsonIgnore
    public JsonNullable<Amount> amount() {
        return this.amount;
    }

    @JsonIgnore
    public JsonNullable<NextInvoice> nextInvoice() {
        return this.nextInvoice;
    }

    @JsonIgnore
    public JsonNullable<NextPayment> nextPayment() {
        return this.nextPayment;
    }

    @JsonIgnore
    public String payerId() {
        return this.payerId;
    }

    @JsonIgnore
    public JsonNullable<Payer> payer() {
        return this.payer;
    }

    @JsonIgnore
    public boolean isFreeTrial() {
        return this.isFreeTrial;
    }

    @JsonIgnore
    public JsonNullable<Long> periodStart() {
        return this.periodStart;
    }

    @JsonIgnore
    public JsonNullable<Long> periodEnd() {
        return this.periodEnd;
    }

    @JsonIgnore
    public String prorationDate() {
        return this.prorationDate;
    }

    @JsonIgnore
    public JsonNullable<Long> canceledAt() {
        return this.canceledAt;
    }

    @JsonIgnore
    public JsonNullable<Long> pastDueAt() {
        return this.pastDueAt;
    }

    @JsonIgnore
    public JsonNullable<Long> endedAt() {
        return this.endedAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommerceSubscriptionItem withObject(CommerceSubscriptionItemObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public CommerceSubscriptionItem withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public CommerceSubscriptionItem withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public CommerceSubscriptionItem withStatus(CommerceSubscriptionItemStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public CommerceSubscriptionItem withCredit(Credit credit) {
        Utils.checkNotNull(credit, "credit");
        this.credit = JsonNullable.of((Object)credit);
        return this;
    }

    public CommerceSubscriptionItem withCredit(JsonNullable<? extends Credit> credit) {
        Utils.checkNotNull(credit, "credit");
        this.credit = credit;
        return this;
    }

    public CommerceSubscriptionItem withPlanId(String planId) {
        Utils.checkNotNull(planId, "planId");
        this.planId = planId;
        return this;
    }

    public CommerceSubscriptionItem withPlan(Plan plan) {
        Utils.checkNotNull(plan, "plan");
        this.plan = Optional.ofNullable(plan);
        return this;
    }

    public CommerceSubscriptionItem withPlan(Optional<? extends Plan> plan) {
        Utils.checkNotNull(plan, "plan");
        this.plan = plan;
        return this;
    }

    public CommerceSubscriptionItem withPlanPeriod(PlanPeriod planPeriod) {
        Utils.checkNotNull(planPeriod, "planPeriod");
        this.planPeriod = planPeriod;
        return this;
    }

    public CommerceSubscriptionItem withPaymentSourceId(String paymentSourceId) {
        Utils.checkNotNull(paymentSourceId, "paymentSourceId");
        this.paymentSourceId = paymentSourceId;
        return this;
    }

    public CommerceSubscriptionItem withPaymentSource(PaymentSource paymentSource) {
        Utils.checkNotNull(paymentSource, "paymentSource");
        this.paymentSource = JsonNullable.of((Object)paymentSource);
        return this;
    }

    public CommerceSubscriptionItem withPaymentSource(JsonNullable<? extends PaymentSource> paymentSource) {
        Utils.checkNotNull(paymentSource, "paymentSource");
        this.paymentSource = paymentSource;
        return this;
    }

    public CommerceSubscriptionItem withLifetimePaid(LifetimePaid lifetimePaid) {
        Utils.checkNotNull(lifetimePaid, "lifetimePaid");
        this.lifetimePaid = JsonNullable.of((Object)lifetimePaid);
        return this;
    }

    public CommerceSubscriptionItem withLifetimePaid(JsonNullable<? extends LifetimePaid> lifetimePaid) {
        Utils.checkNotNull(lifetimePaid, "lifetimePaid");
        this.lifetimePaid = lifetimePaid;
        return this;
    }

    public CommerceSubscriptionItem withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = JsonNullable.of((Object)amount);
        return this;
    }

    public CommerceSubscriptionItem withAmount(JsonNullable<? extends Amount> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public CommerceSubscriptionItem withNextInvoice(NextInvoice nextInvoice) {
        Utils.checkNotNull(nextInvoice, "nextInvoice");
        this.nextInvoice = JsonNullable.of((Object)nextInvoice);
        return this;
    }

    public CommerceSubscriptionItem withNextInvoice(JsonNullable<? extends NextInvoice> nextInvoice) {
        Utils.checkNotNull(nextInvoice, "nextInvoice");
        this.nextInvoice = nextInvoice;
        return this;
    }

    public CommerceSubscriptionItem withNextPayment(NextPayment nextPayment) {
        Utils.checkNotNull(nextPayment, "nextPayment");
        this.nextPayment = JsonNullable.of((Object)nextPayment);
        return this;
    }

    public CommerceSubscriptionItem withNextPayment(JsonNullable<? extends NextPayment> nextPayment) {
        Utils.checkNotNull(nextPayment, "nextPayment");
        this.nextPayment = nextPayment;
        return this;
    }

    public CommerceSubscriptionItem withPayerId(String payerId) {
        Utils.checkNotNull(payerId, "payerId");
        this.payerId = payerId;
        return this;
    }

    public CommerceSubscriptionItem withPayer(Payer payer) {
        Utils.checkNotNull(payer, "payer");
        this.payer = JsonNullable.of((Object)payer);
        return this;
    }

    public CommerceSubscriptionItem withPayer(JsonNullable<? extends Payer> payer) {
        Utils.checkNotNull(payer, "payer");
        this.payer = payer;
        return this;
    }

    public CommerceSubscriptionItem withIsFreeTrial(boolean isFreeTrial) {
        Utils.checkNotNull(isFreeTrial, "isFreeTrial");
        this.isFreeTrial = isFreeTrial;
        return this;
    }

    public CommerceSubscriptionItem withPeriodStart(long periodStart) {
        Utils.checkNotNull(periodStart, "periodStart");
        this.periodStart = JsonNullable.of((Object)periodStart);
        return this;
    }

    public CommerceSubscriptionItem withPeriodStart(JsonNullable<Long> periodStart) {
        Utils.checkNotNull(periodStart, "periodStart");
        this.periodStart = periodStart;
        return this;
    }

    public CommerceSubscriptionItem withPeriodEnd(long periodEnd) {
        Utils.checkNotNull(periodEnd, "periodEnd");
        this.periodEnd = JsonNullable.of((Object)periodEnd);
        return this;
    }

    public CommerceSubscriptionItem withPeriodEnd(JsonNullable<Long> periodEnd) {
        Utils.checkNotNull(periodEnd, "periodEnd");
        this.periodEnd = periodEnd;
        return this;
    }

    public CommerceSubscriptionItem withProrationDate(String prorationDate) {
        Utils.checkNotNull(prorationDate, "prorationDate");
        this.prorationDate = prorationDate;
        return this;
    }

    public CommerceSubscriptionItem withCanceledAt(long canceledAt) {
        Utils.checkNotNull(canceledAt, "canceledAt");
        this.canceledAt = JsonNullable.of((Object)canceledAt);
        return this;
    }

    public CommerceSubscriptionItem withCanceledAt(JsonNullable<Long> canceledAt) {
        Utils.checkNotNull(canceledAt, "canceledAt");
        this.canceledAt = canceledAt;
        return this;
    }

    public CommerceSubscriptionItem withPastDueAt(long pastDueAt) {
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        this.pastDueAt = JsonNullable.of((Object)pastDueAt);
        return this;
    }

    public CommerceSubscriptionItem withPastDueAt(JsonNullable<Long> pastDueAt) {
        Utils.checkNotNull(pastDueAt, "pastDueAt");
        this.pastDueAt = pastDueAt;
        return this;
    }

    public CommerceSubscriptionItem withEndedAt(long endedAt) {
        Utils.checkNotNull(endedAt, "endedAt");
        this.endedAt = JsonNullable.of((Object)endedAt);
        return this;
    }

    public CommerceSubscriptionItem withEndedAt(JsonNullable<Long> endedAt) {
        Utils.checkNotNull(endedAt, "endedAt");
        this.endedAt = endedAt;
        return this;
    }

    public CommerceSubscriptionItem withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public CommerceSubscriptionItem withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommerceSubscriptionItem other = (CommerceSubscriptionItem)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.credit, other.credit) && Utils.enhancedDeepEquals(this.planId, other.planId) && Utils.enhancedDeepEquals(this.plan, other.plan) && Utils.enhancedDeepEquals((Object)this.planPeriod, (Object)other.planPeriod) && Utils.enhancedDeepEquals(this.paymentSourceId, other.paymentSourceId) && Utils.enhancedDeepEquals(this.paymentSource, other.paymentSource) && Utils.enhancedDeepEquals(this.lifetimePaid, other.lifetimePaid) && Utils.enhancedDeepEquals(this.amount, other.amount) && Utils.enhancedDeepEquals(this.nextInvoice, other.nextInvoice) && Utils.enhancedDeepEquals(this.nextPayment, other.nextPayment) && Utils.enhancedDeepEquals(this.payerId, other.payerId) && Utils.enhancedDeepEquals(this.payer, other.payer) && Utils.enhancedDeepEquals(this.isFreeTrial, other.isFreeTrial) && Utils.enhancedDeepEquals(this.periodStart, other.periodStart) && Utils.enhancedDeepEquals(this.periodEnd, other.periodEnd) && Utils.enhancedDeepEquals(this.prorationDate, other.prorationDate) && Utils.enhancedDeepEquals(this.canceledAt, other.canceledAt) && Utils.enhancedDeepEquals(this.pastDueAt, other.pastDueAt) && Utils.enhancedDeepEquals(this.endedAt, other.endedAt) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.instanceId, this.status, this.credit, this.planId, this.plan, this.planPeriod, this.paymentSourceId, this.paymentSource, this.lifetimePaid, this.amount, this.nextInvoice, this.nextPayment, this.payerId, this.payer, this.isFreeTrial, this.periodStart, this.periodEnd, this.prorationDate, this.canceledAt, this.pastDueAt, this.endedAt, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(CommerceSubscriptionItem.class, new Object[]{"object", this.object, "id", this.id, "instanceId", this.instanceId, "status", this.status, "credit", this.credit, "planId", this.planId, "plan", this.plan, "planPeriod", this.planPeriod, "paymentSourceId", this.paymentSourceId, "paymentSource", this.paymentSource, "lifetimePaid", this.lifetimePaid, "amount", this.amount, "nextInvoice", this.nextInvoice, "nextPayment", this.nextPayment, "payerId", this.payerId, "payer", this.payer, "isFreeTrial", this.isFreeTrial, "periodStart", this.periodStart, "periodEnd", this.periodEnd, "prorationDate", this.prorationDate, "canceledAt", this.canceledAt, "pastDueAt", this.pastDueAt, "endedAt", this.endedAt, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private CommerceSubscriptionItemObject object;
        private String id;
        private String instanceId;
        private CommerceSubscriptionItemStatus status;
        private JsonNullable<? extends Credit> credit = JsonNullable.undefined();
        private String planId;
        private Optional<? extends Plan> plan = Optional.empty();
        private PlanPeriod planPeriod;
        private String paymentSourceId;
        private JsonNullable<? extends PaymentSource> paymentSource = JsonNullable.undefined();
        private JsonNullable<? extends LifetimePaid> lifetimePaid = JsonNullable.undefined();
        private JsonNullable<? extends Amount> amount = JsonNullable.undefined();
        private JsonNullable<? extends NextInvoice> nextInvoice = JsonNullable.undefined();
        private JsonNullable<? extends NextPayment> nextPayment = JsonNullable.undefined();
        private String payerId;
        private JsonNullable<? extends Payer> payer = JsonNullable.undefined();
        private Boolean isFreeTrial;
        private JsonNullable<Long> periodStart = JsonNullable.undefined();
        private JsonNullable<Long> periodEnd = JsonNullable.undefined();
        private String prorationDate;
        private JsonNullable<Long> canceledAt = JsonNullable.undefined();
        private JsonNullable<Long> pastDueAt = JsonNullable.undefined();
        private JsonNullable<Long> endedAt = JsonNullable.undefined();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(CommerceSubscriptionItemObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder status(CommerceSubscriptionItemStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder credit(Credit credit) {
            Utils.checkNotNull(credit, "credit");
            this.credit = JsonNullable.of((Object)credit);
            return this;
        }

        public Builder credit(JsonNullable<? extends Credit> credit) {
            Utils.checkNotNull(credit, "credit");
            this.credit = credit;
            return this;
        }

        public Builder planId(String planId) {
            Utils.checkNotNull(planId, "planId");
            this.planId = planId;
            return this;
        }

        public Builder plan(Plan plan) {
            Utils.checkNotNull(plan, "plan");
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        public Builder plan(Optional<? extends Plan> plan) {
            Utils.checkNotNull(plan, "plan");
            this.plan = plan;
            return this;
        }

        public Builder planPeriod(PlanPeriod planPeriod) {
            Utils.checkNotNull(planPeriod, "planPeriod");
            this.planPeriod = planPeriod;
            return this;
        }

        public Builder paymentSourceId(String paymentSourceId) {
            Utils.checkNotNull(paymentSourceId, "paymentSourceId");
            this.paymentSourceId = paymentSourceId;
            return this;
        }

        public Builder paymentSource(PaymentSource paymentSource) {
            Utils.checkNotNull(paymentSource, "paymentSource");
            this.paymentSource = JsonNullable.of((Object)paymentSource);
            return this;
        }

        public Builder paymentSource(JsonNullable<? extends PaymentSource> paymentSource) {
            Utils.checkNotNull(paymentSource, "paymentSource");
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder lifetimePaid(LifetimePaid lifetimePaid) {
            Utils.checkNotNull(lifetimePaid, "lifetimePaid");
            this.lifetimePaid = JsonNullable.of((Object)lifetimePaid);
            return this;
        }

        public Builder lifetimePaid(JsonNullable<? extends LifetimePaid> lifetimePaid) {
            Utils.checkNotNull(lifetimePaid, "lifetimePaid");
            this.lifetimePaid = lifetimePaid;
            return this;
        }

        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = JsonNullable.of((Object)amount);
            return this;
        }

        public Builder amount(JsonNullable<? extends Amount> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder nextInvoice(NextInvoice nextInvoice) {
            Utils.checkNotNull(nextInvoice, "nextInvoice");
            this.nextInvoice = JsonNullable.of((Object)nextInvoice);
            return this;
        }

        public Builder nextInvoice(JsonNullable<? extends NextInvoice> nextInvoice) {
            Utils.checkNotNull(nextInvoice, "nextInvoice");
            this.nextInvoice = nextInvoice;
            return this;
        }

        public Builder nextPayment(NextPayment nextPayment) {
            Utils.checkNotNull(nextPayment, "nextPayment");
            this.nextPayment = JsonNullable.of((Object)nextPayment);
            return this;
        }

        public Builder nextPayment(JsonNullable<? extends NextPayment> nextPayment) {
            Utils.checkNotNull(nextPayment, "nextPayment");
            this.nextPayment = nextPayment;
            return this;
        }

        public Builder payerId(String payerId) {
            Utils.checkNotNull(payerId, "payerId");
            this.payerId = payerId;
            return this;
        }

        public Builder payer(Payer payer) {
            Utils.checkNotNull(payer, "payer");
            this.payer = JsonNullable.of((Object)payer);
            return this;
        }

        public Builder payer(JsonNullable<? extends Payer> payer) {
            Utils.checkNotNull(payer, "payer");
            this.payer = payer;
            return this;
        }

        public Builder isFreeTrial(boolean isFreeTrial) {
            Utils.checkNotNull(isFreeTrial, "isFreeTrial");
            this.isFreeTrial = isFreeTrial;
            return this;
        }

        public Builder periodStart(long periodStart) {
            Utils.checkNotNull(periodStart, "periodStart");
            this.periodStart = JsonNullable.of((Object)periodStart);
            return this;
        }

        public Builder periodStart(JsonNullable<Long> periodStart) {
            Utils.checkNotNull(periodStart, "periodStart");
            this.periodStart = periodStart;
            return this;
        }

        public Builder periodEnd(long periodEnd) {
            Utils.checkNotNull(periodEnd, "periodEnd");
            this.periodEnd = JsonNullable.of((Object)periodEnd);
            return this;
        }

        public Builder periodEnd(JsonNullable<Long> periodEnd) {
            Utils.checkNotNull(periodEnd, "periodEnd");
            this.periodEnd = periodEnd;
            return this;
        }

        public Builder prorationDate(String prorationDate) {
            Utils.checkNotNull(prorationDate, "prorationDate");
            this.prorationDate = prorationDate;
            return this;
        }

        public Builder canceledAt(long canceledAt) {
            Utils.checkNotNull(canceledAt, "canceledAt");
            this.canceledAt = JsonNullable.of((Object)canceledAt);
            return this;
        }

        public Builder canceledAt(JsonNullable<Long> canceledAt) {
            Utils.checkNotNull(canceledAt, "canceledAt");
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder pastDueAt(long pastDueAt) {
            Utils.checkNotNull(pastDueAt, "pastDueAt");
            this.pastDueAt = JsonNullable.of((Object)pastDueAt);
            return this;
        }

        public Builder pastDueAt(JsonNullable<Long> pastDueAt) {
            Utils.checkNotNull(pastDueAt, "pastDueAt");
            this.pastDueAt = pastDueAt;
            return this;
        }

        public Builder endedAt(long endedAt) {
            Utils.checkNotNull(endedAt, "endedAt");
            this.endedAt = JsonNullable.of((Object)endedAt);
            return this;
        }

        public Builder endedAt(JsonNullable<Long> endedAt) {
            Utils.checkNotNull(endedAt, "endedAt");
            this.endedAt = endedAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public CommerceSubscriptionItem build() {
            return new CommerceSubscriptionItem(this.object, this.id, this.instanceId, this.status, this.credit, this.planId, this.plan, this.planPeriod, this.paymentSourceId, this.paymentSource, this.lifetimePaid, this.amount, this.nextInvoice, this.nextPayment, this.payerId, this.payer, this.isFreeTrial, this.periodStart, this.periodEnd, this.prorationDate, this.canceledAt, this.pastDueAt, this.endedAt, this.createdAt, this.updatedAt);
        }
    }
}

