/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceMoneyResponse;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CommerceSubscriptionNextPayment {
    @JsonProperty(value="time")
    private long time;
    @JsonProperty(value="date")
    private long date;
    @JsonProperty(value="amount")
    private CommerceMoneyResponse amount;

    @JsonCreator
    public CommerceSubscriptionNextPayment(@JsonProperty(value="time") long time, @JsonProperty(value="date") long date, @JsonProperty(value="amount") CommerceMoneyResponse amount) {
        Utils.checkNotNull(time, "time");
        Utils.checkNotNull(date, "date");
        Utils.checkNotNull(amount, "amount");
        this.time = time;
        this.date = date;
        this.amount = amount;
    }

    @JsonIgnore
    public long time() {
        return this.time;
    }

    @JsonIgnore
    public long date() {
        return this.date;
    }

    @JsonIgnore
    public CommerceMoneyResponse amount() {
        return this.amount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommerceSubscriptionNextPayment withTime(long time) {
        Utils.checkNotNull(time, "time");
        this.time = time;
        return this;
    }

    public CommerceSubscriptionNextPayment withDate(long date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    public CommerceSubscriptionNextPayment withAmount(CommerceMoneyResponse amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommerceSubscriptionNextPayment other = (CommerceSubscriptionNextPayment)o;
        return Utils.enhancedDeepEquals(this.time, other.time) && Utils.enhancedDeepEquals(this.date, other.date) && Utils.enhancedDeepEquals(this.amount, other.amount);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.time, this.date, this.amount);
    }

    public String toString() {
        return Utils.toString(CommerceSubscriptionNextPayment.class, "time", this.time, "date", this.date, "amount", this.amount);
    }

    public static final class Builder {
        private Long time;
        private Long date;
        private CommerceMoneyResponse amount;

        private Builder() {
        }

        public Builder time(long time) {
            Utils.checkNotNull(time, "time");
            this.time = time;
            return this;
        }

        public Builder date(long date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public Builder amount(CommerceMoneyResponse amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public CommerceSubscriptionNextPayment build() {
            return new CommerceSubscriptionNextPayment(this.time, this.date, this.amount);
        }
    }
}

