/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceSubscriptionItemAmount;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Credit {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="amount")
    private JsonNullable<? extends CommerceSubscriptionItemAmount> amount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cycle_remaining_percent")
    private Optional<Float> cycleRemainingPercent;

    @JsonCreator
    public Credit(@JsonProperty(value="amount") JsonNullable<? extends CommerceSubscriptionItemAmount> amount, @JsonProperty(value="cycle_remaining_percent") Optional<Float> cycleRemainingPercent) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(cycleRemainingPercent, "cycleRemainingPercent");
        this.amount = amount;
        this.cycleRemainingPercent = cycleRemainingPercent;
    }

    public Credit() {
        this((JsonNullable<? extends CommerceSubscriptionItemAmount>)JsonNullable.undefined(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<CommerceSubscriptionItemAmount> amount() {
        return this.amount;
    }

    @JsonIgnore
    public Optional<Float> cycleRemainingPercent() {
        return this.cycleRemainingPercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Credit withAmount(CommerceSubscriptionItemAmount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = JsonNullable.of((Object)amount);
        return this;
    }

    public Credit withAmount(JsonNullable<? extends CommerceSubscriptionItemAmount> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public Credit withCycleRemainingPercent(float cycleRemainingPercent) {
        Utils.checkNotNull(Float.valueOf(cycleRemainingPercent), "cycleRemainingPercent");
        this.cycleRemainingPercent = Optional.ofNullable(Float.valueOf(cycleRemainingPercent));
        return this;
    }

    public Credit withCycleRemainingPercent(Optional<Float> cycleRemainingPercent) {
        Utils.checkNotNull(cycleRemainingPercent, "cycleRemainingPercent");
        this.cycleRemainingPercent = cycleRemainingPercent;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credit other = (Credit)o;
        return Utils.enhancedDeepEquals(this.amount, other.amount) && Utils.enhancedDeepEquals(this.cycleRemainingPercent, other.cycleRemainingPercent);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.amount, this.cycleRemainingPercent);
    }

    public String toString() {
        return Utils.toString(Credit.class, "amount", this.amount, "cycleRemainingPercent", this.cycleRemainingPercent);
    }

    public static final class Builder {
        private JsonNullable<? extends CommerceSubscriptionItemAmount> amount = JsonNullable.undefined();
        private Optional<Float> cycleRemainingPercent = Optional.empty();

        private Builder() {
        }

        public Builder amount(CommerceSubscriptionItemAmount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = JsonNullable.of((Object)amount);
            return this;
        }

        public Builder amount(JsonNullable<? extends CommerceSubscriptionItemAmount> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder cycleRemainingPercent(float cycleRemainingPercent) {
            Utils.checkNotNull(Float.valueOf(cycleRemainingPercent), "cycleRemainingPercent");
            this.cycleRemainingPercent = Optional.ofNullable(Float.valueOf(cycleRemainingPercent));
            return this;
        }

        public Builder cycleRemainingPercent(Optional<Float> cycleRemainingPercent) {
            Utils.checkNotNull(cycleRemainingPercent, "cycleRemainingPercent");
            this.cycleRemainingPercent = cycleRemainingPercent;
            return this;
        }

        public Credit build() {
            return new Credit(this.amount, this.cycleRemainingPercent);
        }
    }
}

