/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class DeletedObject {
    @JsonProperty(value="object")
    private String object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="slug")
    private Optional<String> slug;
    @JsonProperty(value="deleted")
    private boolean deleted;

    @JsonCreator
    public DeletedObject(@JsonProperty(value="object") String object, @JsonProperty(value="id") Optional<String> id, @JsonProperty(value="slug") Optional<String> slug, @JsonProperty(value="deleted") boolean deleted) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(deleted, "deleted");
        this.object = object;
        this.id = id;
        this.slug = slug;
        this.deleted = deleted;
    }

    public DeletedObject(String object, boolean deleted) {
        this(object, Optional.empty(), Optional.empty(), deleted);
    }

    @JsonIgnore
    public String object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> slug() {
        return this.slug;
    }

    @JsonIgnore
    public boolean deleted() {
        return this.deleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeletedObject withObject(String object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public DeletedObject withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public DeletedObject withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public DeletedObject withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = Optional.ofNullable(slug);
        return this;
    }

    public DeletedObject withSlug(Optional<String> slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public DeletedObject withDeleted(boolean deleted) {
        Utils.checkNotNull(deleted, "deleted");
        this.deleted = deleted;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletedObject other = (DeletedObject)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.deleted, other.deleted);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.object, this.id, this.slug, this.deleted);
    }

    public String toString() {
        return Utils.toString(DeletedObject.class, "object", this.object, "id", this.id, "slug", this.slug, "deleted", this.deleted);
    }

    public static final class Builder {
        private String object;
        private Optional<String> id = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Boolean deleted;

        private Builder() {
        }

        public Builder object(String object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        public Builder slug(Optional<String> slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder deleted(boolean deleted) {
            Utils.checkNotNull(deleted, "deleted");
            this.deleted = deleted;
            return this;
        }

        public DeletedObject build() {
            return new DeletedObject(this.object, this.id, this.slug, this.deleted);
        }
    }
}

