/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmailAddressObject {
    public static final EmailAddressObject EMAIL_ADDRESS = new EmailAddressObject("email_address");
    private static final Map<String, EmailAddressObject> values = EmailAddressObject.createValuesMap();
    private static final Map<String, EmailAddressObjectEnum> enums = EmailAddressObject.createEnumsMap();
    private final String value;

    private EmailAddressObject(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmailAddressObject of(String value) {
        Class<EmailAddressObject> clazz = EmailAddressObject.class;
        synchronized (EmailAddressObject.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmailAddressObject((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmailAddressObjectEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailAddressObject other = (EmailAddressObject)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmailAddressObject [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmailAddressObject[] values() {
        Class<EmailAddressObject> clazz = EmailAddressObject.class;
        synchronized (EmailAddressObject.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmailAddressObject[0]);
        }
    }

    private static final Map<String, EmailAddressObject> createValuesMap() {
        LinkedHashMap<String, EmailAddressObject> map = new LinkedHashMap<String, EmailAddressObject>();
        map.put("email_address", EMAIL_ADDRESS);
        return map;
    }

    private static final Map<String, EmailAddressObjectEnum> createEnumsMap() {
        HashMap<String, EmailAddressObjectEnum> map = new HashMap<String, EmailAddressObjectEnum>();
        map.put("email_address", EmailAddressObjectEnum.EMAIL_ADDRESS);
        return map;
    }

    public static enum EmailAddressObjectEnum {
        EMAIL_ADDRESS("email_address");

        private final String value;

        private EmailAddressObjectEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmailAddressObject> {
        protected _Deserializer() {
            super(EmailAddressObject.class);
        }

        public EmailAddressObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmailAddressObject.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmailAddressObject> {
        protected _Serializer() {
            super(EmailAddressObject.class);
        }

        public void serialize(EmailAddressObject value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

