/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Verification;
import com.clerk.backend_api.models.components.VerificationEmailLinkVerificationObject;
import com.clerk.backend_api.models.components.VerificationEmailLinkVerificationStatus;
import com.clerk.backend_api.models.components.VerificationEmailLinkVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class EmailLink
implements Verification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationEmailLinkVerificationObject> object;
    @JsonProperty(value="status")
    private VerificationEmailLinkVerificationStatus status;
    @JsonProperty(value="strategy")
    private VerificationEmailLinkVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public EmailLink(@JsonProperty(value="object") Optional<? extends VerificationEmailLinkVerificationObject> object, @JsonProperty(value="status") VerificationEmailLinkVerificationStatus status, @JsonProperty(value="strategy") VerificationEmailLinkVerificationStrategy strategy, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.attempts = attempts;
        this.expireAt = expireAt;
        this.verifiedAtClient = verifiedAtClient;
    }

    public EmailLink(VerificationEmailLinkVerificationStatus status, VerificationEmailLinkVerificationStrategy strategy) {
        this(Optional.empty(), status, strategy, Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationEmailLinkVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public VerificationEmailLinkVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EmailLink withObject(VerificationEmailLinkVerificationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public EmailLink withObject(Optional<? extends VerificationEmailLinkVerificationObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public EmailLink withStatus(VerificationEmailLinkVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public EmailLink withStrategy(VerificationEmailLinkVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public EmailLink withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public EmailLink withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public EmailLink withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public EmailLink withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public EmailLink withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public EmailLink withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailLink other = (EmailLink)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals((Object)this.strategy, (Object)other.strategy) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(EmailLink.class, new Object[]{"object", this.object, "status", this.status, "strategy", this.strategy, "attempts", this.attempts, "expireAt", this.expireAt, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Optional<? extends VerificationEmailLinkVerificationObject> object = Optional.empty();
        private VerificationEmailLinkVerificationStatus status;
        private VerificationEmailLinkVerificationStrategy strategy;
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationEmailLinkVerificationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationEmailLinkVerificationObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationEmailLinkVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(VerificationEmailLinkVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public EmailLink build() {
            return new EmailLink(this.object, this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient);
        }
    }
}

