/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.FeatureResponseObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class FeatureResponse {
    @JsonProperty(value="object")
    private FeatureResponseObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="avatar_url")
    private String avatarUrl;

    @JsonCreator
    public FeatureResponse(@JsonProperty(value="object") FeatureResponseObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="slug") String slug, @JsonProperty(value="avatar_url") String avatarUrl) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(avatarUrl, "avatarUrl");
        this.object = object;
        this.id = id;
        this.name = name;
        this.description = description;
        this.slug = slug;
        this.avatarUrl = avatarUrl;
    }

    @JsonIgnore
    public FeatureResponseObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String description() {
        return this.description;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public String avatarUrl() {
        return this.avatarUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public FeatureResponse withObject(FeatureResponseObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public FeatureResponse withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public FeatureResponse withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public FeatureResponse withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public FeatureResponse withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public FeatureResponse withAvatarUrl(String avatarUrl) {
        Utils.checkNotNull(avatarUrl, "avatarUrl");
        this.avatarUrl = avatarUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureResponse other = (FeatureResponse)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.description, other.description) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.avatarUrl, other.avatarUrl);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.name, this.description, this.slug, this.avatarUrl});
    }

    public String toString() {
        return Utils.toString(FeatureResponse.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "description", this.description, "slug", this.slug, "avatarUrl", this.avatarUrl});
    }

    public static final class Builder {
        private FeatureResponseObject object;
        private String id;
        private String name;
        private String description;
        private String slug;
        private String avatarUrl;

        private Builder() {
        }

        public Builder object(FeatureResponseObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder avatarUrl(String avatarUrl) {
            Utils.checkNotNull(avatarUrl, "avatarUrl");
            this.avatarUrl = avatarUrl;
            return this;
        }

        public FeatureResponse build() {
            return new FeatureResponse(this.object, this.id, this.name, this.description, this.slug, this.avatarUrl);
        }
    }
}

