/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InstanceRestrictionsObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class InstanceRestrictions {
    @JsonProperty(value="object")
    private InstanceRestrictionsObject object;
    @JsonProperty(value="allowlist")
    private boolean allowlist;
    @JsonProperty(value="blocklist")
    private boolean blocklist;
    @JsonProperty(value="allowlist_blocklist_disabled_on_sign_in")
    private boolean allowlistBlocklistDisabledOnSignIn;
    @JsonProperty(value="block_email_subaddresses")
    private boolean blockEmailSubaddresses;
    @JsonProperty(value="block_disposable_email_domains")
    private boolean blockDisposableEmailDomains;

    @JsonCreator
    public InstanceRestrictions(@JsonProperty(value="object") InstanceRestrictionsObject object, @JsonProperty(value="allowlist") boolean allowlist, @JsonProperty(value="blocklist") boolean blocklist, @JsonProperty(value="allowlist_blocklist_disabled_on_sign_in") boolean allowlistBlocklistDisabledOnSignIn, @JsonProperty(value="block_email_subaddresses") boolean blockEmailSubaddresses, @JsonProperty(value="block_disposable_email_domains") boolean blockDisposableEmailDomains) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(allowlist, "allowlist");
        Utils.checkNotNull(blocklist, "blocklist");
        Utils.checkNotNull(allowlistBlocklistDisabledOnSignIn, "allowlistBlocklistDisabledOnSignIn");
        Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
        Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
        this.object = object;
        this.allowlist = allowlist;
        this.blocklist = blocklist;
        this.allowlistBlocklistDisabledOnSignIn = allowlistBlocklistDisabledOnSignIn;
        this.blockEmailSubaddresses = blockEmailSubaddresses;
        this.blockDisposableEmailDomains = blockDisposableEmailDomains;
    }

    @JsonIgnore
    public InstanceRestrictionsObject object() {
        return this.object;
    }

    @JsonIgnore
    public boolean allowlist() {
        return this.allowlist;
    }

    @JsonIgnore
    public boolean blocklist() {
        return this.blocklist;
    }

    @JsonIgnore
    public boolean allowlistBlocklistDisabledOnSignIn() {
        return this.allowlistBlocklistDisabledOnSignIn;
    }

    @JsonIgnore
    public boolean blockEmailSubaddresses() {
        return this.blockEmailSubaddresses;
    }

    @JsonIgnore
    public boolean blockDisposableEmailDomains() {
        return this.blockDisposableEmailDomains;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InstanceRestrictions withObject(InstanceRestrictionsObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public InstanceRestrictions withAllowlist(boolean allowlist) {
        Utils.checkNotNull(allowlist, "allowlist");
        this.allowlist = allowlist;
        return this;
    }

    public InstanceRestrictions withBlocklist(boolean blocklist) {
        Utils.checkNotNull(blocklist, "blocklist");
        this.blocklist = blocklist;
        return this;
    }

    public InstanceRestrictions withAllowlistBlocklistDisabledOnSignIn(boolean allowlistBlocklistDisabledOnSignIn) {
        Utils.checkNotNull(allowlistBlocklistDisabledOnSignIn, "allowlistBlocklistDisabledOnSignIn");
        this.allowlistBlocklistDisabledOnSignIn = allowlistBlocklistDisabledOnSignIn;
        return this;
    }

    public InstanceRestrictions withBlockEmailSubaddresses(boolean blockEmailSubaddresses) {
        Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
        this.blockEmailSubaddresses = blockEmailSubaddresses;
        return this;
    }

    public InstanceRestrictions withBlockDisposableEmailDomains(boolean blockDisposableEmailDomains) {
        Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
        this.blockDisposableEmailDomains = blockDisposableEmailDomains;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceRestrictions other = (InstanceRestrictions)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.allowlist, other.allowlist) && Utils.enhancedDeepEquals(this.blocklist, other.blocklist) && Utils.enhancedDeepEquals(this.allowlistBlocklistDisabledOnSignIn, other.allowlistBlocklistDisabledOnSignIn) && Utils.enhancedDeepEquals(this.blockEmailSubaddresses, other.blockEmailSubaddresses) && Utils.enhancedDeepEquals(this.blockDisposableEmailDomains, other.blockDisposableEmailDomains);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.allowlist, this.blocklist, this.allowlistBlocklistDisabledOnSignIn, this.blockEmailSubaddresses, this.blockDisposableEmailDomains});
    }

    public String toString() {
        return Utils.toString(InstanceRestrictions.class, new Object[]{"object", this.object, "allowlist", this.allowlist, "blocklist", this.blocklist, "allowlistBlocklistDisabledOnSignIn", this.allowlistBlocklistDisabledOnSignIn, "blockEmailSubaddresses", this.blockEmailSubaddresses, "blockDisposableEmailDomains", this.blockDisposableEmailDomains});
    }

    public static final class Builder {
        private InstanceRestrictionsObject object;
        private Boolean allowlist;
        private Boolean blocklist;
        private Boolean allowlistBlocklistDisabledOnSignIn;
        private Boolean blockEmailSubaddresses;
        private Boolean blockDisposableEmailDomains;

        private Builder() {
        }

        public Builder object(InstanceRestrictionsObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder allowlist(boolean allowlist) {
            Utils.checkNotNull(allowlist, "allowlist");
            this.allowlist = allowlist;
            return this;
        }

        public Builder blocklist(boolean blocklist) {
            Utils.checkNotNull(blocklist, "blocklist");
            this.blocklist = blocklist;
            return this;
        }

        public Builder allowlistBlocklistDisabledOnSignIn(boolean allowlistBlocklistDisabledOnSignIn) {
            Utils.checkNotNull(allowlistBlocklistDisabledOnSignIn, "allowlistBlocklistDisabledOnSignIn");
            this.allowlistBlocklistDisabledOnSignIn = allowlistBlocklistDisabledOnSignIn;
            return this;
        }

        public Builder blockEmailSubaddresses(boolean blockEmailSubaddresses) {
            Utils.checkNotNull(blockEmailSubaddresses, "blockEmailSubaddresses");
            this.blockEmailSubaddresses = blockEmailSubaddresses;
            return this;
        }

        public Builder blockDisposableEmailDomains(boolean blockDisposableEmailDomains) {
            Utils.checkNotNull(blockDisposableEmailDomains, "blockDisposableEmailDomains");
            this.blockDisposableEmailDomains = blockDisposableEmailDomains;
            return this;
        }

        public InstanceRestrictions build() {
            return new InstanceRestrictions(this.object, this.allowlist, this.blocklist, this.allowlistBlocklistDisabledOnSignIn, this.blockEmailSubaddresses, this.blockDisposableEmailDomains);
        }
    }
}

