/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InstanceSettingsObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class InstanceSettings {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends InstanceSettingsObject> object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="restricted_to_allowlist")
    private Optional<Boolean> restrictedToAllowlist;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="from_email_address")
    private Optional<String> fromEmailAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="progressive_sign_up")
    private Optional<Boolean> progressiveSignUp;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="enhanced_email_deliverability")
    private Optional<Boolean> enhancedEmailDeliverability;

    @JsonCreator
    public InstanceSettings(@JsonProperty(value="object") Optional<? extends InstanceSettingsObject> object, @JsonProperty(value="id") Optional<String> id, @JsonProperty(value="restricted_to_allowlist") Optional<Boolean> restrictedToAllowlist, @JsonProperty(value="from_email_address") Optional<String> fromEmailAddress, @JsonProperty(value="progressive_sign_up") Optional<Boolean> progressiveSignUp, @JsonProperty(value="enhanced_email_deliverability") Optional<Boolean> enhancedEmailDeliverability) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(restrictedToAllowlist, "restrictedToAllowlist");
        Utils.checkNotNull(fromEmailAddress, "fromEmailAddress");
        Utils.checkNotNull(progressiveSignUp, "progressiveSignUp");
        Utils.checkNotNull(enhancedEmailDeliverability, "enhancedEmailDeliverability");
        this.object = object;
        this.id = id;
        this.restrictedToAllowlist = restrictedToAllowlist;
        this.fromEmailAddress = fromEmailAddress;
        this.progressiveSignUp = progressiveSignUp;
        this.enhancedEmailDeliverability = enhancedEmailDeliverability;
    }

    public InstanceSettings() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<InstanceSettingsObject> object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Boolean> restrictedToAllowlist() {
        return this.restrictedToAllowlist;
    }

    @JsonIgnore
    public Optional<String> fromEmailAddress() {
        return this.fromEmailAddress;
    }

    @JsonIgnore
    public Optional<Boolean> progressiveSignUp() {
        return this.progressiveSignUp;
    }

    @JsonIgnore
    public Optional<Boolean> enhancedEmailDeliverability() {
        return this.enhancedEmailDeliverability;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InstanceSettings withObject(InstanceSettingsObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public InstanceSettings withObject(Optional<? extends InstanceSettingsObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public InstanceSettings withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public InstanceSettings withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public InstanceSettings withRestrictedToAllowlist(boolean restrictedToAllowlist) {
        Utils.checkNotNull(restrictedToAllowlist, "restrictedToAllowlist");
        this.restrictedToAllowlist = Optional.ofNullable(restrictedToAllowlist);
        return this;
    }

    public InstanceSettings withRestrictedToAllowlist(Optional<Boolean> restrictedToAllowlist) {
        Utils.checkNotNull(restrictedToAllowlist, "restrictedToAllowlist");
        this.restrictedToAllowlist = restrictedToAllowlist;
        return this;
    }

    public InstanceSettings withFromEmailAddress(String fromEmailAddress) {
        Utils.checkNotNull(fromEmailAddress, "fromEmailAddress");
        this.fromEmailAddress = Optional.ofNullable(fromEmailAddress);
        return this;
    }

    public InstanceSettings withFromEmailAddress(Optional<String> fromEmailAddress) {
        Utils.checkNotNull(fromEmailAddress, "fromEmailAddress");
        this.fromEmailAddress = fromEmailAddress;
        return this;
    }

    public InstanceSettings withProgressiveSignUp(boolean progressiveSignUp) {
        Utils.checkNotNull(progressiveSignUp, "progressiveSignUp");
        this.progressiveSignUp = Optional.ofNullable(progressiveSignUp);
        return this;
    }

    public InstanceSettings withProgressiveSignUp(Optional<Boolean> progressiveSignUp) {
        Utils.checkNotNull(progressiveSignUp, "progressiveSignUp");
        this.progressiveSignUp = progressiveSignUp;
        return this;
    }

    public InstanceSettings withEnhancedEmailDeliverability(boolean enhancedEmailDeliverability) {
        Utils.checkNotNull(enhancedEmailDeliverability, "enhancedEmailDeliverability");
        this.enhancedEmailDeliverability = Optional.ofNullable(enhancedEmailDeliverability);
        return this;
    }

    public InstanceSettings withEnhancedEmailDeliverability(Optional<Boolean> enhancedEmailDeliverability) {
        Utils.checkNotNull(enhancedEmailDeliverability, "enhancedEmailDeliverability");
        this.enhancedEmailDeliverability = enhancedEmailDeliverability;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceSettings other = (InstanceSettings)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.restrictedToAllowlist, other.restrictedToAllowlist) && Utils.enhancedDeepEquals(this.fromEmailAddress, other.fromEmailAddress) && Utils.enhancedDeepEquals(this.progressiveSignUp, other.progressiveSignUp) && Utils.enhancedDeepEquals(this.enhancedEmailDeliverability, other.enhancedEmailDeliverability);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.object, this.id, this.restrictedToAllowlist, this.fromEmailAddress, this.progressiveSignUp, this.enhancedEmailDeliverability);
    }

    public String toString() {
        return Utils.toString(InstanceSettings.class, "object", this.object, "id", this.id, "restrictedToAllowlist", this.restrictedToAllowlist, "fromEmailAddress", this.fromEmailAddress, "progressiveSignUp", this.progressiveSignUp, "enhancedEmailDeliverability", this.enhancedEmailDeliverability);
    }

    public static final class Builder {
        private Optional<? extends InstanceSettingsObject> object = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<Boolean> restrictedToAllowlist = Optional.empty();
        private Optional<String> fromEmailAddress = Optional.empty();
        private Optional<Boolean> progressiveSignUp = Optional.empty();
        private Optional<Boolean> enhancedEmailDeliverability = Optional.empty();

        private Builder() {
        }

        public Builder object(InstanceSettingsObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends InstanceSettingsObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder restrictedToAllowlist(boolean restrictedToAllowlist) {
            Utils.checkNotNull(restrictedToAllowlist, "restrictedToAllowlist");
            this.restrictedToAllowlist = Optional.ofNullable(restrictedToAllowlist);
            return this;
        }

        public Builder restrictedToAllowlist(Optional<Boolean> restrictedToAllowlist) {
            Utils.checkNotNull(restrictedToAllowlist, "restrictedToAllowlist");
            this.restrictedToAllowlist = restrictedToAllowlist;
            return this;
        }

        public Builder fromEmailAddress(String fromEmailAddress) {
            Utils.checkNotNull(fromEmailAddress, "fromEmailAddress");
            this.fromEmailAddress = Optional.ofNullable(fromEmailAddress);
            return this;
        }

        public Builder fromEmailAddress(Optional<String> fromEmailAddress) {
            Utils.checkNotNull(fromEmailAddress, "fromEmailAddress");
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public Builder progressiveSignUp(boolean progressiveSignUp) {
            Utils.checkNotNull(progressiveSignUp, "progressiveSignUp");
            this.progressiveSignUp = Optional.ofNullable(progressiveSignUp);
            return this;
        }

        public Builder progressiveSignUp(Optional<Boolean> progressiveSignUp) {
            Utils.checkNotNull(progressiveSignUp, "progressiveSignUp");
            this.progressiveSignUp = progressiveSignUp;
            return this;
        }

        public Builder enhancedEmailDeliverability(boolean enhancedEmailDeliverability) {
            Utils.checkNotNull(enhancedEmailDeliverability, "enhancedEmailDeliverability");
            this.enhancedEmailDeliverability = Optional.ofNullable(enhancedEmailDeliverability);
            return this;
        }

        public Builder enhancedEmailDeliverability(Optional<Boolean> enhancedEmailDeliverability) {
            Utils.checkNotNull(enhancedEmailDeliverability, "enhancedEmailDeliverability");
            this.enhancedEmailDeliverability = enhancedEmailDeliverability;
            return this;
        }

        public InstanceSettings build() {
            return new InstanceSettings(this.object, this.id, this.restrictedToAllowlist, this.fromEmailAddress, this.progressiveSignUp, this.enhancedEmailDeliverability);
        }
    }
}

