/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InvitationObject;
import com.clerk.backend_api.models.components.InvitationStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Invitation {
    @JsonProperty(value="object")
    private InvitationObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="revoked")
    private Optional<Boolean> revoked;
    @JsonProperty(value="status")
    private InvitationStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private Optional<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_at")
    private JsonNullable<Long> expiresAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public Invitation(@JsonProperty(value="object") InvitationObject object, @JsonProperty(value="id") String id, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="revoked") Optional<Boolean> revoked, @JsonProperty(value="status") InvitationStatus status, @JsonProperty(value="url") Optional<String> url, @JsonProperty(value="expires_at") JsonNullable<Long> expiresAt, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(emailAddress, "emailAddress");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(revoked, "revoked");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(expiresAt, "expiresAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.emailAddress = emailAddress;
        this.publicMetadata = publicMetadata;
        this.revoked = revoked;
        this.status = status;
        this.url = url;
        this.expiresAt = expiresAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Invitation(InvitationObject object, String id, String emailAddress, Map<String, Object> publicMetadata, InvitationStatus status, long createdAt, long updatedAt) {
        this(object, id, emailAddress, publicMetadata, Optional.empty(), status, Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public InvitationObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<Boolean> revoked() {
        return this.revoked;
    }

    @JsonIgnore
    public InvitationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<Long> expiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Invitation withObject(InvitationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Invitation withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Invitation withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public Invitation withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public Invitation withRevoked(boolean revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = Optional.ofNullable(revoked);
        return this;
    }

    public Invitation withRevoked(Optional<Boolean> revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = revoked;
        return this;
    }

    public Invitation withStatus(InvitationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Invitation withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = Optional.ofNullable(url);
        return this;
    }

    public Invitation withUrl(Optional<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Invitation withExpiresAt(long expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = JsonNullable.of((Object)expiresAt);
        return this;
    }

    public Invitation withExpiresAt(JsonNullable<Long> expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public Invitation withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public Invitation withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invitation other = (Invitation)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals(this.publicMetadata, other.publicMetadata) && Utils.enhancedDeepEquals(this.revoked, other.revoked) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.url, other.url) && Utils.enhancedDeepEquals(this.expiresAt, other.expiresAt) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.emailAddress, this.publicMetadata, this.revoked, this.status, this.url, this.expiresAt, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(Invitation.class, new Object[]{"object", this.object, "id", this.id, "emailAddress", this.emailAddress, "publicMetadata", this.publicMetadata, "revoked", this.revoked, "status", this.status, "url", this.url, "expiresAt", this.expiresAt, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private InvitationObject object;
        private String id;
        private String emailAddress;
        private Map<String, Object> publicMetadata;
        private Optional<Boolean> revoked = Optional.empty();
        private InvitationStatus status;
        private Optional<String> url = Optional.empty();
        private JsonNullable<Long> expiresAt = JsonNullable.undefined();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(InvitationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder revoked(boolean revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = Optional.ofNullable(revoked);
            return this;
        }

        public Builder revoked(Optional<Boolean> revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = revoked;
            return this;
        }

        public Builder status(InvitationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = Optional.ofNullable(url);
            return this;
        }

        public Builder url(Optional<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = JsonNullable.of((Object)expiresAt);
            return this;
        }

        public Builder expiresAt(JsonNullable<Long> expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Invitation build() {
            return new Invitation(this.object, this.id, this.emailAddress, this.publicMetadata, this.revoked, this.status, this.url, this.expiresAt, this.createdAt, this.updatedAt);
        }
    }
}

