/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Keys;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;

public class Jwks {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="keys")
    private Optional<? extends List<Keys>> keys;

    @JsonCreator
    public Jwks(@JsonProperty(value="keys") Optional<? extends List<Keys>> keys) {
        Utils.checkNotNull(keys, "keys");
        this.keys = keys;
    }

    public Jwks() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<List<Keys>> keys() {
        return this.keys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Jwks withKeys(List<Keys> keys) {
        Utils.checkNotNull(keys, "keys");
        this.keys = Optional.ofNullable(keys);
        return this;
    }

    public Jwks withKeys(Optional<? extends List<Keys>> keys) {
        Utils.checkNotNull(keys, "keys");
        this.keys = keys;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jwks other = (Jwks)o;
        return Utils.enhancedDeepEquals(this.keys, other.keys);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.keys);
    }

    public String toString() {
        return Utils.toString(Jwks.class, "keys", this.keys);
    }

    public static final class Builder {
        private Optional<? extends List<Keys>> keys = Optional.empty();

        private Builder() {
        }

        public Builder keys(List<Keys> keys) {
            Utils.checkNotNull(keys, "keys");
            this.keys = Optional.ofNullable(keys);
            return this;
        }

        public Builder keys(Optional<? extends List<Keys>> keys) {
            Utils.checkNotNull(keys, "keys");
            this.keys = keys;
            return this;
        }

        public Jwks build() {
            return new Jwks(this.keys);
        }
    }
}

