/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class Keys {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="use")
    private Optional<String> use;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="kty")
    private Optional<String> kty;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="kid")
    private Optional<String> kid;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="alg")
    private Optional<String> alg;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="n")
    private Optional<String> n;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="e")
    private Optional<String> e;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="x")
    private Optional<String> x;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="crv")
    private Optional<String> crv;

    @JsonCreator
    public Keys(@JsonProperty(value="use") Optional<String> use, @JsonProperty(value="kty") Optional<String> kty, @JsonProperty(value="kid") Optional<String> kid, @JsonProperty(value="alg") Optional<String> alg, @JsonProperty(value="n") Optional<String> n, @JsonProperty(value="e") Optional<String> e, @JsonProperty(value="x") Optional<String> x, @JsonProperty(value="crv") Optional<String> crv) {
        Utils.checkNotNull(use, "use");
        Utils.checkNotNull(kty, "kty");
        Utils.checkNotNull(kid, "kid");
        Utils.checkNotNull(alg, "alg");
        Utils.checkNotNull(n, "n");
        Utils.checkNotNull(e, "e");
        Utils.checkNotNull(x, "x");
        Utils.checkNotNull(crv, "crv");
        this.use = use;
        this.kty = kty;
        this.kid = kid;
        this.alg = alg;
        this.n = n;
        this.e = e;
        this.x = x;
        this.crv = crv;
    }

    public Keys() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> use() {
        return this.use;
    }

    @JsonIgnore
    public Optional<String> kty() {
        return this.kty;
    }

    @JsonIgnore
    public Optional<String> kid() {
        return this.kid;
    }

    @JsonIgnore
    public Optional<String> alg() {
        return this.alg;
    }

    @JsonIgnore
    public Optional<String> n() {
        return this.n;
    }

    @JsonIgnore
    public Optional<String> e() {
        return this.e;
    }

    @JsonIgnore
    public Optional<String> x() {
        return this.x;
    }

    @JsonIgnore
    public Optional<String> crv() {
        return this.crv;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Keys withUse(String use) {
        Utils.checkNotNull(use, "use");
        this.use = Optional.ofNullable(use);
        return this;
    }

    public Keys withUse(Optional<String> use) {
        Utils.checkNotNull(use, "use");
        this.use = use;
        return this;
    }

    public Keys withKty(String kty) {
        Utils.checkNotNull(kty, "kty");
        this.kty = Optional.ofNullable(kty);
        return this;
    }

    public Keys withKty(Optional<String> kty) {
        Utils.checkNotNull(kty, "kty");
        this.kty = kty;
        return this;
    }

    public Keys withKid(String kid) {
        Utils.checkNotNull(kid, "kid");
        this.kid = Optional.ofNullable(kid);
        return this;
    }

    public Keys withKid(Optional<String> kid) {
        Utils.checkNotNull(kid, "kid");
        this.kid = kid;
        return this;
    }

    public Keys withAlg(String alg) {
        Utils.checkNotNull(alg, "alg");
        this.alg = Optional.ofNullable(alg);
        return this;
    }

    public Keys withAlg(Optional<String> alg) {
        Utils.checkNotNull(alg, "alg");
        this.alg = alg;
        return this;
    }

    public Keys withN(String n) {
        Utils.checkNotNull(n, "n");
        this.n = Optional.ofNullable(n);
        return this;
    }

    public Keys withN(Optional<String> n) {
        Utils.checkNotNull(n, "n");
        this.n = n;
        return this;
    }

    public Keys withE(String e) {
        Utils.checkNotNull(e, "e");
        this.e = Optional.ofNullable(e);
        return this;
    }

    public Keys withE(Optional<String> e) {
        Utils.checkNotNull(e, "e");
        this.e = e;
        return this;
    }

    public Keys withX(String x) {
        Utils.checkNotNull(x, "x");
        this.x = Optional.ofNullable(x);
        return this;
    }

    public Keys withX(Optional<String> x) {
        Utils.checkNotNull(x, "x");
        this.x = x;
        return this;
    }

    public Keys withCrv(String crv) {
        Utils.checkNotNull(crv, "crv");
        this.crv = Optional.ofNullable(crv);
        return this;
    }

    public Keys withCrv(Optional<String> crv) {
        Utils.checkNotNull(crv, "crv");
        this.crv = crv;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keys other = (Keys)o;
        return Utils.enhancedDeepEquals(this.use, other.use) && Utils.enhancedDeepEquals(this.kty, other.kty) && Utils.enhancedDeepEquals(this.kid, other.kid) && Utils.enhancedDeepEquals(this.alg, other.alg) && Utils.enhancedDeepEquals(this.n, other.n) && Utils.enhancedDeepEquals(this.e, other.e) && Utils.enhancedDeepEquals(this.x, other.x) && Utils.enhancedDeepEquals(this.crv, other.crv);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.use, this.kty, this.kid, this.alg, this.n, this.e, this.x, this.crv);
    }

    public String toString() {
        return Utils.toString(Keys.class, "use", this.use, "kty", this.kty, "kid", this.kid, "alg", this.alg, "n", this.n, "e", this.e, "x", this.x, "crv", this.crv);
    }

    public static final class Builder {
        private Optional<String> use = Optional.empty();
        private Optional<String> kty = Optional.empty();
        private Optional<String> kid = Optional.empty();
        private Optional<String> alg = Optional.empty();
        private Optional<String> n = Optional.empty();
        private Optional<String> e = Optional.empty();
        private Optional<String> x = Optional.empty();
        private Optional<String> crv = Optional.empty();

        private Builder() {
        }

        public Builder use(String use) {
            Utils.checkNotNull(use, "use");
            this.use = Optional.ofNullable(use);
            return this;
        }

        public Builder use(Optional<String> use) {
            Utils.checkNotNull(use, "use");
            this.use = use;
            return this;
        }

        public Builder kty(String kty) {
            Utils.checkNotNull(kty, "kty");
            this.kty = Optional.ofNullable(kty);
            return this;
        }

        public Builder kty(Optional<String> kty) {
            Utils.checkNotNull(kty, "kty");
            this.kty = kty;
            return this;
        }

        public Builder kid(String kid) {
            Utils.checkNotNull(kid, "kid");
            this.kid = Optional.ofNullable(kid);
            return this;
        }

        public Builder kid(Optional<String> kid) {
            Utils.checkNotNull(kid, "kid");
            this.kid = kid;
            return this;
        }

        public Builder alg(String alg) {
            Utils.checkNotNull(alg, "alg");
            this.alg = Optional.ofNullable(alg);
            return this;
        }

        public Builder alg(Optional<String> alg) {
            Utils.checkNotNull(alg, "alg");
            this.alg = alg;
            return this;
        }

        public Builder n(String n) {
            Utils.checkNotNull(n, "n");
            this.n = Optional.ofNullable(n);
            return this;
        }

        public Builder n(Optional<String> n) {
            Utils.checkNotNull(n, "n");
            this.n = n;
            return this;
        }

        public Builder e(String e) {
            Utils.checkNotNull(e, "e");
            this.e = Optional.ofNullable(e);
            return this;
        }

        public Builder e(Optional<String> e) {
            Utils.checkNotNull(e, "e");
            this.e = e;
            return this;
        }

        public Builder x(String x) {
            Utils.checkNotNull(x, "x");
            this.x = Optional.ofNullable(x);
            return this;
        }

        public Builder x(Optional<String> x) {
            Utils.checkNotNull(x, "x");
            this.x = x;
            return this;
        }

        public Builder crv(String crv) {
            Utils.checkNotNull(crv, "crv");
            this.crv = Optional.ofNullable(crv);
            return this;
        }

        public Builder crv(Optional<String> crv) {
            Utils.checkNotNull(crv, "crv");
            this.crv = crv;
            return this;
        }

        public Keys build() {
            return new Keys(this.use, this.kty, this.kid, this.alg, this.n, this.e, this.x, this.crv);
        }
    }
}

