/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.MachineObject;
import com.clerk.backend_api.models.components.MachineWithoutScopedMachines;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;

public class Machine {
    @JsonProperty(value="object")
    private MachineObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="default_token_ttl")
    private Optional<Long> defaultTokenTtl;
    @JsonProperty(value="scoped_machines")
    private List<MachineWithoutScopedMachines> scopedMachines;

    @JsonCreator
    public Machine(@JsonProperty(value="object") MachineObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="default_token_ttl") Optional<Long> defaultTokenTtl, @JsonProperty(value="scoped_machines") List<MachineWithoutScopedMachines> scopedMachines) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        Utils.checkNotNull(scopedMachines, "scopedMachines");
        this.object = object;
        this.id = id;
        this.name = name;
        this.instanceId = instanceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.defaultTokenTtl = defaultTokenTtl;
        this.scopedMachines = scopedMachines;
    }

    public Machine(MachineObject object, String id, String name, String instanceId, long createdAt, long updatedAt, List<MachineWithoutScopedMachines> scopedMachines) {
        this(object, id, name, instanceId, createdAt, updatedAt, Optional.empty(), scopedMachines);
    }

    @JsonIgnore
    public MachineObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<Long> defaultTokenTtl() {
        return this.defaultTokenTtl;
    }

    @JsonIgnore
    public List<MachineWithoutScopedMachines> scopedMachines() {
        return this.scopedMachines;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Machine withObject(MachineObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Machine withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Machine withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Machine withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public Machine withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public Machine withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public Machine withDefaultTokenTtl(long defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
        return this;
    }

    public Machine withDefaultTokenTtl(Optional<Long> defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = defaultTokenTtl;
        return this;
    }

    public Machine withScopedMachines(List<MachineWithoutScopedMachines> scopedMachines) {
        Utils.checkNotNull(scopedMachines, "scopedMachines");
        this.scopedMachines = scopedMachines;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Machine other = (Machine)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) && Utils.enhancedDeepEquals(this.defaultTokenTtl, other.defaultTokenTtl) && Utils.enhancedDeepEquals(this.scopedMachines, other.scopedMachines);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.name, this.instanceId, this.createdAt, this.updatedAt, this.defaultTokenTtl, this.scopedMachines});
    }

    public String toString() {
        return Utils.toString(Machine.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "instanceId", this.instanceId, "createdAt", this.createdAt, "updatedAt", this.updatedAt, "defaultTokenTtl", this.defaultTokenTtl, "scopedMachines", this.scopedMachines});
    }

    public static final class Builder {
        private MachineObject object;
        private String id;
        private String name;
        private String instanceId;
        private Long createdAt;
        private Long updatedAt;
        private Optional<Long> defaultTokenTtl;
        private List<MachineWithoutScopedMachines> scopedMachines;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_DefaultTokenTtl = new LazySingletonValue<Optional<Long>>("default_token_ttl", "3600", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder object(MachineObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder defaultTokenTtl(long defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
            return this;
        }

        public Builder defaultTokenTtl(Optional<Long> defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = defaultTokenTtl;
            return this;
        }

        public Builder scopedMachines(List<MachineWithoutScopedMachines> scopedMachines) {
            Utils.checkNotNull(scopedMachines, "scopedMachines");
            this.scopedMachines = scopedMachines;
            return this;
        }

        public Machine build() {
            if (this.defaultTokenTtl == null) {
                this.defaultTokenTtl = _SINGLETON_VALUE_DefaultTokenTtl.value();
            }
            return new Machine(this.object, this.id, this.name, this.instanceId, this.createdAt, this.updatedAt, this.defaultTokenTtl, this.scopedMachines);
        }
    }
}

