/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.MachineScopeObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MachineScope {
    @JsonProperty(value="object")
    private MachineScopeObject object;
    @JsonProperty(value="from_machine_id")
    private String fromMachineId;
    @JsonProperty(value="to_machine_id")
    private String toMachineId;
    @JsonProperty(value="created_at")
    private long createdAt;

    @JsonCreator
    public MachineScope(@JsonProperty(value="object") MachineScopeObject object, @JsonProperty(value="from_machine_id") String fromMachineId, @JsonProperty(value="to_machine_id") String toMachineId, @JsonProperty(value="created_at") long createdAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(fromMachineId, "fromMachineId");
        Utils.checkNotNull(toMachineId, "toMachineId");
        Utils.checkNotNull(createdAt, "createdAt");
        this.object = object;
        this.fromMachineId = fromMachineId;
        this.toMachineId = toMachineId;
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public MachineScopeObject object() {
        return this.object;
    }

    @JsonIgnore
    public String fromMachineId() {
        return this.fromMachineId;
    }

    @JsonIgnore
    public String toMachineId() {
        return this.toMachineId;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MachineScope withObject(MachineScopeObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public MachineScope withFromMachineId(String fromMachineId) {
        Utils.checkNotNull(fromMachineId, "fromMachineId");
        this.fromMachineId = fromMachineId;
        return this;
    }

    public MachineScope withToMachineId(String toMachineId) {
        Utils.checkNotNull(toMachineId, "toMachineId");
        this.toMachineId = toMachineId;
        return this;
    }

    public MachineScope withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineScope other = (MachineScope)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.fromMachineId, other.fromMachineId) && Utils.enhancedDeepEquals(this.toMachineId, other.toMachineId) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.fromMachineId, this.toMachineId, this.createdAt});
    }

    public String toString() {
        return Utils.toString(MachineScope.class, new Object[]{"object", this.object, "fromMachineId", this.fromMachineId, "toMachineId", this.toMachineId, "createdAt", this.createdAt});
    }

    public static final class Builder {
        private MachineScopeObject object;
        private String fromMachineId;
        private String toMachineId;
        private Long createdAt;

        private Builder() {
        }

        public Builder object(MachineScopeObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder fromMachineId(String fromMachineId) {
            Utils.checkNotNull(fromMachineId, "fromMachineId");
            this.fromMachineId = fromMachineId;
            return this;
        }

        public Builder toMachineId(String toMachineId) {
            Utils.checkNotNull(toMachineId, "toMachineId");
            this.toMachineId = toMachineId;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public MachineScope build() {
            return new MachineScope(this.object, this.fromMachineId, this.toMachineId, this.createdAt);
        }
    }
}

