/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.MachineSecretKeyObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MachineSecretKey {
    @JsonProperty(value="object")
    private MachineSecretKeyObject object;
    @JsonProperty(value="secret")
    private String secret;

    @JsonCreator
    public MachineSecretKey(@JsonProperty(value="object") MachineSecretKeyObject object, @JsonProperty(value="secret") String secret) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(secret, "secret");
        this.object = object;
        this.secret = secret;
    }

    @JsonIgnore
    public MachineSecretKeyObject object() {
        return this.object;
    }

    @JsonIgnore
    public String secret() {
        return this.secret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MachineSecretKey withObject(MachineSecretKeyObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public MachineSecretKey withSecret(String secret) {
        Utils.checkNotNull(secret, "secret");
        this.secret = secret;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineSecretKey other = (MachineSecretKey)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.secret, other.secret);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.secret});
    }

    public String toString() {
        return Utils.toString(MachineSecretKey.class, new Object[]{"object", this.object, "secret", this.secret});
    }

    public static final class Builder {
        private MachineSecretKeyObject object;
        private String secret;

        private Builder() {
        }

        public Builder object(MachineSecretKeyObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder secret(String secret) {
            Utils.checkNotNull(secret, "secret");
            this.secret = secret;
            return this;
        }

        public MachineSecretKey build() {
            return new MachineSecretKey(this.object, this.secret);
        }
    }
}

