/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceSubscriptionItemNextPaymentAmount;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openapitools.jackson.nullable.JsonNullable;

public class NextPayment {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="amount")
    private JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount> amount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="date")
    private JsonNullable<Long> date;

    @JsonCreator
    public NextPayment(@JsonProperty(value="amount") JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount> amount, @JsonProperty(value="date") JsonNullable<Long> date) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(date, "date");
        this.amount = amount;
        this.date = date;
    }

    public NextPayment() {
        this((JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<CommerceSubscriptionItemNextPaymentAmount> amount() {
        return this.amount;
    }

    @JsonIgnore
    public JsonNullable<Long> date() {
        return this.date;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NextPayment withAmount(CommerceSubscriptionItemNextPaymentAmount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = JsonNullable.of((Object)amount);
        return this;
    }

    public NextPayment withAmount(JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public NextPayment withDate(long date) {
        Utils.checkNotNull(date, "date");
        this.date = JsonNullable.of((Object)date);
        return this;
    }

    public NextPayment withDate(JsonNullable<Long> date) {
        Utils.checkNotNull(date, "date");
        this.date = date;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NextPayment other = (NextPayment)o;
        return Utils.enhancedDeepEquals(this.amount, other.amount) && Utils.enhancedDeepEquals(this.date, other.date);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.amount, this.date);
    }

    public String toString() {
        return Utils.toString(NextPayment.class, "amount", this.amount, "date", this.date);
    }

    public static final class Builder {
        private JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount> amount = JsonNullable.undefined();
        private JsonNullable<Long> date = JsonNullable.undefined();

        private Builder() {
        }

        public Builder amount(CommerceSubscriptionItemNextPaymentAmount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = JsonNullable.of((Object)amount);
            return this;
        }

        public Builder amount(JsonNullable<? extends CommerceSubscriptionItemNextPaymentAmount> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder date(long date) {
            Utils.checkNotNull(date, "date");
            this.date = JsonNullable.of((Object)date);
            return this;
        }

        public Builder date(JsonNullable<Long> date) {
            Utils.checkNotNull(date, "date");
            this.date = date;
            return this;
        }

        public NextPayment build() {
            return new NextPayment(this.amount, this.date);
        }
    }
}

