/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OAuthAccessTokenObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OAuthAccessToken {
    @JsonProperty(value="object")
    private OAuthAccessTokenObject object;
    @JsonProperty(value="external_account_id")
    private String externalAccountId;
    @JsonProperty(value="provider_user_id")
    private String providerUserId;
    @JsonProperty(value="token")
    private String token;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expires_at")
    private Optional<Long> expiresAt;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="label")
    private Optional<String> label;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="scopes")
    private Optional<? extends List<String>> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token_secret")
    private Optional<String> tokenSecret;

    @JsonCreator
    public OAuthAccessToken(@JsonProperty(value="object") OAuthAccessTokenObject object, @JsonProperty(value="external_account_id") String externalAccountId, @JsonProperty(value="provider_user_id") String providerUserId, @JsonProperty(value="token") String token, @JsonProperty(value="expires_at") Optional<Long> expiresAt, @JsonProperty(value="provider") String provider, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="label") Optional<String> label, @JsonProperty(value="scopes") Optional<? extends List<String>> scopes, @JsonProperty(value="token_secret") Optional<String> tokenSecret) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        Utils.checkNotNull(providerUserId, "providerUserId");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(expiresAt, "expiresAt");
        Utils.checkNotNull(provider, "provider");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        this.object = object;
        this.externalAccountId = externalAccountId;
        this.providerUserId = providerUserId;
        this.token = token;
        this.expiresAt = expiresAt;
        this.provider = provider;
        this.publicMetadata = publicMetadata;
        this.label = label;
        this.scopes = scopes;
        this.tokenSecret = tokenSecret;
    }

    public OAuthAccessToken(OAuthAccessTokenObject object, String externalAccountId, String providerUserId, String token, String provider, Map<String, Object> publicMetadata) {
        this(object, externalAccountId, providerUserId, token, Optional.empty(), provider, publicMetadata, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public OAuthAccessTokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String externalAccountId() {
        return this.externalAccountId;
    }

    @JsonIgnore
    public String providerUserId() {
        return this.providerUserId;
    }

    @JsonIgnore
    public String token() {
        return this.token;
    }

    @JsonIgnore
    public Optional<Long> expiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<String> label() {
        return this.label;
    }

    @JsonIgnore
    public Optional<List<String>> scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public Optional<String> tokenSecret() {
        return this.tokenSecret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public OAuthAccessToken withObject(OAuthAccessTokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OAuthAccessToken withExternalAccountId(String externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = externalAccountId;
        return this;
    }

    public OAuthAccessToken withProviderUserId(String providerUserId) {
        Utils.checkNotNull(providerUserId, "providerUserId");
        this.providerUserId = providerUserId;
        return this;
    }

    public OAuthAccessToken withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public OAuthAccessToken withExpiresAt(long expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = Optional.ofNullable(expiresAt);
        return this;
    }

    public OAuthAccessToken withExpiresAt(Optional<Long> expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public OAuthAccessToken withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public OAuthAccessToken withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public OAuthAccessToken withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = Optional.ofNullable(label);
        return this;
    }

    public OAuthAccessToken withLabel(Optional<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public OAuthAccessToken withScopes(List<String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = Optional.ofNullable(scopes);
        return this;
    }

    public OAuthAccessToken withScopes(Optional<? extends List<String>> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public OAuthAccessToken withTokenSecret(String tokenSecret) {
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        this.tokenSecret = Optional.ofNullable(tokenSecret);
        return this;
    }

    public OAuthAccessToken withTokenSecret(Optional<String> tokenSecret) {
        Utils.checkNotNull(tokenSecret, "tokenSecret");
        this.tokenSecret = tokenSecret;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthAccessToken other = (OAuthAccessToken)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.externalAccountId, other.externalAccountId) && Utils.enhancedDeepEquals(this.providerUserId, other.providerUserId) && Utils.enhancedDeepEquals(this.token, other.token) && Utils.enhancedDeepEquals(this.expiresAt, other.expiresAt) && Utils.enhancedDeepEquals(this.provider, other.provider) && Utils.enhancedDeepEquals(this.publicMetadata, other.publicMetadata) && Utils.enhancedDeepEquals(this.label, other.label) && Utils.enhancedDeepEquals(this.scopes, other.scopes) && Utils.enhancedDeepEquals(this.tokenSecret, other.tokenSecret);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.externalAccountId, this.providerUserId, this.token, this.expiresAt, this.provider, this.publicMetadata, this.label, this.scopes, this.tokenSecret});
    }

    public String toString() {
        return Utils.toString(OAuthAccessToken.class, new Object[]{"object", this.object, "externalAccountId", this.externalAccountId, "providerUserId", this.providerUserId, "token", this.token, "expiresAt", this.expiresAt, "provider", this.provider, "publicMetadata", this.publicMetadata, "label", this.label, "scopes", this.scopes, "tokenSecret", this.tokenSecret});
    }

    public static final class Builder {
        private OAuthAccessTokenObject object;
        private String externalAccountId;
        private String providerUserId;
        private String token;
        private Optional<Long> expiresAt = Optional.empty();
        private String provider;
        private Map<String, Object> publicMetadata;
        private Optional<String> label = Optional.empty();
        private Optional<? extends List<String>> scopes = Optional.empty();
        private Optional<String> tokenSecret = Optional.empty();

        private Builder() {
        }

        public Builder object(OAuthAccessTokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder externalAccountId(String externalAccountId) {
            Utils.checkNotNull(externalAccountId, "externalAccountId");
            this.externalAccountId = externalAccountId;
            return this;
        }

        public Builder providerUserId(String providerUserId) {
            Utils.checkNotNull(providerUserId, "providerUserId");
            this.providerUserId = providerUserId;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public Builder expiresAt(Optional<Long> expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = Optional.ofNullable(label);
            return this;
        }

        public Builder label(Optional<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        public Builder scopes(Optional<? extends List<String>> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder tokenSecret(String tokenSecret) {
            Utils.checkNotNull(tokenSecret, "tokenSecret");
            this.tokenSecret = Optional.ofNullable(tokenSecret);
            return this;
        }

        public Builder tokenSecret(Optional<String> tokenSecret) {
            Utils.checkNotNull(tokenSecret, "tokenSecret");
            this.tokenSecret = tokenSecret;
            return this;
        }

        public OAuthAccessToken build() {
            return new OAuthAccessToken(this.object, this.externalAccountId, this.providerUserId, this.token, this.expiresAt, this.provider, this.publicMetadata, this.label, this.scopes, this.tokenSecret);
        }
    }
}

