/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OAuthApplicationObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;

public class OAuthApplication {
    @JsonProperty(value="object")
    private OAuthApplicationObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="client_uri")
    private Optional<String> clientUri;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="client_image_url")
    private Optional<String> clientImageUrl;
    @JsonProperty(value="dynamically_registered")
    private boolean dynamicallyRegistered;
    @JsonProperty(value="consent_screen_enabled")
    private boolean consentScreenEnabled;
    @JsonProperty(value="pkce_required")
    private boolean pkceRequired;
    @JsonProperty(value="public")
    private boolean public_;
    @JsonProperty(value="scopes")
    private String scopes;
    @JsonProperty(value="redirect_uris")
    private List<String> redirectUris;
    @JsonProperty(value="callback_url")
    @Deprecated
    private String callbackUrl;
    @JsonProperty(value="authorize_url")
    private String authorizeUrl;
    @JsonProperty(value="token_fetch_url")
    private String tokenFetchUrl;
    @JsonProperty(value="user_info_url")
    private String userInfoUrl;
    @JsonProperty(value="discovery_url")
    private String discoveryUrl;
    @JsonProperty(value="token_introspection_url")
    private String tokenIntrospectionUrl;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public OAuthApplication(@JsonProperty(value="object") OAuthApplicationObject object, @JsonProperty(value="id") String id, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="name") String name, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="client_uri") Optional<String> clientUri, @JsonProperty(value="client_image_url") Optional<String> clientImageUrl, @JsonProperty(value="dynamically_registered") boolean dynamicallyRegistered, @JsonProperty(value="consent_screen_enabled") boolean consentScreenEnabled, @JsonProperty(value="pkce_required") boolean pkceRequired, @JsonProperty(value="public") boolean public_, @JsonProperty(value="scopes") String scopes, @JsonProperty(value="redirect_uris") List<String> redirectUris, @JsonProperty(value="callback_url") String callbackUrl, @JsonProperty(value="authorize_url") String authorizeUrl, @JsonProperty(value="token_fetch_url") String tokenFetchUrl, @JsonProperty(value="user_info_url") String userInfoUrl, @JsonProperty(value="discovery_url") String discoveryUrl, @JsonProperty(value="token_introspection_url") String tokenIntrospectionUrl, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(clientUri, "clientUri");
        Utils.checkNotNull(clientImageUrl, "clientImageUrl");
        Utils.checkNotNull(dynamicallyRegistered, "dynamicallyRegistered");
        Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
        Utils.checkNotNull(pkceRequired, "pkceRequired");
        Utils.checkNotNull(public_, "public_");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(redirectUris, "redirectUris");
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        Utils.checkNotNull(authorizeUrl, "authorizeUrl");
        Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
        Utils.checkNotNull(userInfoUrl, "userInfoUrl");
        Utils.checkNotNull(discoveryUrl, "discoveryUrl");
        Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.instanceId = instanceId;
        this.name = name;
        this.clientId = clientId;
        this.clientUri = clientUri;
        this.clientImageUrl = clientImageUrl;
        this.dynamicallyRegistered = dynamicallyRegistered;
        this.consentScreenEnabled = consentScreenEnabled;
        this.pkceRequired = pkceRequired;
        this.public_ = public_;
        this.scopes = scopes;
        this.redirectUris = redirectUris;
        this.callbackUrl = callbackUrl;
        this.authorizeUrl = authorizeUrl;
        this.tokenFetchUrl = tokenFetchUrl;
        this.userInfoUrl = userInfoUrl;
        this.discoveryUrl = discoveryUrl;
        this.tokenIntrospectionUrl = tokenIntrospectionUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public OAuthApplication(OAuthApplicationObject object, String id, String instanceId, String name, String clientId, boolean dynamicallyRegistered, boolean consentScreenEnabled, boolean pkceRequired, boolean public_, String scopes, List<String> redirectUris, String callbackUrl, String authorizeUrl, String tokenFetchUrl, String userInfoUrl, String discoveryUrl, String tokenIntrospectionUrl, long createdAt, long updatedAt) {
        this(object, id, instanceId, name, clientId, Optional.empty(), Optional.empty(), dynamicallyRegistered, consentScreenEnabled, pkceRequired, public_, scopes, redirectUris, callbackUrl, authorizeUrl, tokenFetchUrl, userInfoUrl, discoveryUrl, tokenIntrospectionUrl, createdAt, updatedAt);
    }

    @JsonIgnore
    public OAuthApplicationObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public Optional<String> clientUri() {
        return this.clientUri;
    }

    @JsonIgnore
    public Optional<String> clientImageUrl() {
        return this.clientImageUrl;
    }

    @JsonIgnore
    public boolean dynamicallyRegistered() {
        return this.dynamicallyRegistered;
    }

    @JsonIgnore
    public boolean consentScreenEnabled() {
        return this.consentScreenEnabled;
    }

    @JsonIgnore
    public boolean pkceRequired() {
        return this.pkceRequired;
    }

    @JsonIgnore
    public boolean public_() {
        return this.public_;
    }

    @JsonIgnore
    public String scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public List<String> redirectUris() {
        return this.redirectUris;
    }

    @Deprecated
    @JsonIgnore
    public String callbackUrl() {
        return this.callbackUrl;
    }

    @JsonIgnore
    public String authorizeUrl() {
        return this.authorizeUrl;
    }

    @JsonIgnore
    public String tokenFetchUrl() {
        return this.tokenFetchUrl;
    }

    @JsonIgnore
    public String userInfoUrl() {
        return this.userInfoUrl;
    }

    @JsonIgnore
    public String discoveryUrl() {
        return this.discoveryUrl;
    }

    @JsonIgnore
    public String tokenIntrospectionUrl() {
        return this.tokenIntrospectionUrl;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public OAuthApplication withObject(OAuthApplicationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OAuthApplication withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public OAuthApplication withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public OAuthApplication withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public OAuthApplication withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public OAuthApplication withClientUri(String clientUri) {
        Utils.checkNotNull(clientUri, "clientUri");
        this.clientUri = Optional.ofNullable(clientUri);
        return this;
    }

    public OAuthApplication withClientUri(Optional<String> clientUri) {
        Utils.checkNotNull(clientUri, "clientUri");
        this.clientUri = clientUri;
        return this;
    }

    public OAuthApplication withClientImageUrl(String clientImageUrl) {
        Utils.checkNotNull(clientImageUrl, "clientImageUrl");
        this.clientImageUrl = Optional.ofNullable(clientImageUrl);
        return this;
    }

    public OAuthApplication withClientImageUrl(Optional<String> clientImageUrl) {
        Utils.checkNotNull(clientImageUrl, "clientImageUrl");
        this.clientImageUrl = clientImageUrl;
        return this;
    }

    public OAuthApplication withDynamicallyRegistered(boolean dynamicallyRegistered) {
        Utils.checkNotNull(dynamicallyRegistered, "dynamicallyRegistered");
        this.dynamicallyRegistered = dynamicallyRegistered;
        return this;
    }

    public OAuthApplication withConsentScreenEnabled(boolean consentScreenEnabled) {
        Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
        this.consentScreenEnabled = consentScreenEnabled;
        return this;
    }

    public OAuthApplication withPkceRequired(boolean pkceRequired) {
        Utils.checkNotNull(pkceRequired, "pkceRequired");
        this.pkceRequired = pkceRequired;
        return this;
    }

    public OAuthApplication withPublic(boolean public_) {
        Utils.checkNotNull(public_, "public_");
        this.public_ = public_;
        return this;
    }

    public OAuthApplication withScopes(String scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public OAuthApplication withRedirectUris(List<String> redirectUris) {
        Utils.checkNotNull(redirectUris, "redirectUris");
        this.redirectUris = redirectUris;
        return this;
    }

    @Deprecated
    public OAuthApplication withCallbackUrl(String callbackUrl) {
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OAuthApplication withAuthorizeUrl(String authorizeUrl) {
        Utils.checkNotNull(authorizeUrl, "authorizeUrl");
        this.authorizeUrl = authorizeUrl;
        return this;
    }

    public OAuthApplication withTokenFetchUrl(String tokenFetchUrl) {
        Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
        this.tokenFetchUrl = tokenFetchUrl;
        return this;
    }

    public OAuthApplication withUserInfoUrl(String userInfoUrl) {
        Utils.checkNotNull(userInfoUrl, "userInfoUrl");
        this.userInfoUrl = userInfoUrl;
        return this;
    }

    public OAuthApplication withDiscoveryUrl(String discoveryUrl) {
        Utils.checkNotNull(discoveryUrl, "discoveryUrl");
        this.discoveryUrl = discoveryUrl;
        return this;
    }

    public OAuthApplication withTokenIntrospectionUrl(String tokenIntrospectionUrl) {
        Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
        this.tokenIntrospectionUrl = tokenIntrospectionUrl;
        return this;
    }

    public OAuthApplication withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public OAuthApplication withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthApplication other = (OAuthApplication)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.clientId, other.clientId) && Utils.enhancedDeepEquals(this.clientUri, other.clientUri) && Utils.enhancedDeepEquals(this.clientImageUrl, other.clientImageUrl) && Utils.enhancedDeepEquals(this.dynamicallyRegistered, other.dynamicallyRegistered) && Utils.enhancedDeepEquals(this.consentScreenEnabled, other.consentScreenEnabled) && Utils.enhancedDeepEquals(this.pkceRequired, other.pkceRequired) && Utils.enhancedDeepEquals(this.public_, other.public_) && Utils.enhancedDeepEquals(this.scopes, other.scopes) && Utils.enhancedDeepEquals(this.redirectUris, other.redirectUris) && Utils.enhancedDeepEquals(this.callbackUrl, other.callbackUrl) && Utils.enhancedDeepEquals(this.authorizeUrl, other.authorizeUrl) && Utils.enhancedDeepEquals(this.tokenFetchUrl, other.tokenFetchUrl) && Utils.enhancedDeepEquals(this.userInfoUrl, other.userInfoUrl) && Utils.enhancedDeepEquals(this.discoveryUrl, other.discoveryUrl) && Utils.enhancedDeepEquals(this.tokenIntrospectionUrl, other.tokenIntrospectionUrl) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.instanceId, this.name, this.clientId, this.clientUri, this.clientImageUrl, this.dynamicallyRegistered, this.consentScreenEnabled, this.pkceRequired, this.public_, this.scopes, this.redirectUris, this.callbackUrl, this.authorizeUrl, this.tokenFetchUrl, this.userInfoUrl, this.discoveryUrl, this.tokenIntrospectionUrl, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(OAuthApplication.class, new Object[]{"object", this.object, "id", this.id, "instanceId", this.instanceId, "name", this.name, "clientId", this.clientId, "clientUri", this.clientUri, "clientImageUrl", this.clientImageUrl, "dynamicallyRegistered", this.dynamicallyRegistered, "consentScreenEnabled", this.consentScreenEnabled, "pkceRequired", this.pkceRequired, "public_", this.public_, "scopes", this.scopes, "redirectUris", this.redirectUris, "callbackUrl", this.callbackUrl, "authorizeUrl", this.authorizeUrl, "tokenFetchUrl", this.tokenFetchUrl, "userInfoUrl", this.userInfoUrl, "discoveryUrl", this.discoveryUrl, "tokenIntrospectionUrl", this.tokenIntrospectionUrl, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private OAuthApplicationObject object;
        private String id;
        private String instanceId;
        private String name;
        private String clientId;
        private Optional<String> clientUri = Optional.empty();
        private Optional<String> clientImageUrl = Optional.empty();
        private Boolean dynamicallyRegistered;
        private Boolean consentScreenEnabled;
        private Boolean pkceRequired;
        private Boolean public_;
        private String scopes;
        private List<String> redirectUris;
        @Deprecated
        private String callbackUrl;
        private String authorizeUrl;
        private String tokenFetchUrl;
        private String userInfoUrl;
        private String discoveryUrl;
        private String tokenIntrospectionUrl;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(OAuthApplicationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder clientUri(String clientUri) {
            Utils.checkNotNull(clientUri, "clientUri");
            this.clientUri = Optional.ofNullable(clientUri);
            return this;
        }

        public Builder clientUri(Optional<String> clientUri) {
            Utils.checkNotNull(clientUri, "clientUri");
            this.clientUri = clientUri;
            return this;
        }

        public Builder clientImageUrl(String clientImageUrl) {
            Utils.checkNotNull(clientImageUrl, "clientImageUrl");
            this.clientImageUrl = Optional.ofNullable(clientImageUrl);
            return this;
        }

        public Builder clientImageUrl(Optional<String> clientImageUrl) {
            Utils.checkNotNull(clientImageUrl, "clientImageUrl");
            this.clientImageUrl = clientImageUrl;
            return this;
        }

        public Builder dynamicallyRegistered(boolean dynamicallyRegistered) {
            Utils.checkNotNull(dynamicallyRegistered, "dynamicallyRegistered");
            this.dynamicallyRegistered = dynamicallyRegistered;
            return this;
        }

        public Builder consentScreenEnabled(boolean consentScreenEnabled) {
            Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
            this.consentScreenEnabled = consentScreenEnabled;
            return this;
        }

        public Builder pkceRequired(boolean pkceRequired) {
            Utils.checkNotNull(pkceRequired, "pkceRequired");
            this.pkceRequired = pkceRequired;
            return this;
        }

        public Builder public_(boolean public_) {
            Utils.checkNotNull(public_, "public_");
            this.public_ = public_;
            return this;
        }

        public Builder scopes(String scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            Utils.checkNotNull(redirectUris, "redirectUris");
            this.redirectUris = redirectUris;
            return this;
        }

        @Deprecated
        public Builder callbackUrl(String callbackUrl) {
            Utils.checkNotNull(callbackUrl, "callbackUrl");
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder authorizeUrl(String authorizeUrl) {
            Utils.checkNotNull(authorizeUrl, "authorizeUrl");
            this.authorizeUrl = authorizeUrl;
            return this;
        }

        public Builder tokenFetchUrl(String tokenFetchUrl) {
            Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
            this.tokenFetchUrl = tokenFetchUrl;
            return this;
        }

        public Builder userInfoUrl(String userInfoUrl) {
            Utils.checkNotNull(userInfoUrl, "userInfoUrl");
            this.userInfoUrl = userInfoUrl;
            return this;
        }

        public Builder discoveryUrl(String discoveryUrl) {
            Utils.checkNotNull(discoveryUrl, "discoveryUrl");
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        public Builder tokenIntrospectionUrl(String tokenIntrospectionUrl) {
            Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
            this.tokenIntrospectionUrl = tokenIntrospectionUrl;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public OAuthApplication build() {
            return new OAuthApplication(this.object, this.id, this.instanceId, this.name, this.clientId, this.clientUri, this.clientImageUrl, this.dynamicallyRegistered, this.consentScreenEnabled, this.pkceRequired, this.public_, this.scopes, this.redirectUris, this.callbackUrl, this.authorizeUrl, this.tokenFetchUrl, this.userInfoUrl, this.discoveryUrl, this.tokenIntrospectionUrl, this.createdAt, this.updatedAt);
        }
    }
}

