/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ExternalAccountWithVerificationVerification;
import com.clerk.backend_api.models.components.VerificationOauthVerificationError;
import com.clerk.backend_api.models.components.VerificationOauthVerificationObject;
import com.clerk.backend_api.models.components.VerificationOauthVerificationStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Oauth
implements ExternalAccountWithVerificationVerification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationOauthVerificationObject> object;
    @JsonProperty(value="status")
    private VerificationOauthVerificationStatus status;
    @JsonProperty(value="strategy")
    private String strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_verification_redirect_url")
    private Optional<String> externalVerificationRedirectUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends VerificationOauthVerificationError> error;
    @JsonProperty(value="expire_at")
    private long expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Oauth(@JsonProperty(value="object") Optional<? extends VerificationOauthVerificationObject> object, @JsonProperty(value="status") VerificationOauthVerificationStatus status, @JsonProperty(value="strategy") String strategy, @JsonProperty(value="external_verification_redirect_url") Optional<String> externalVerificationRedirectUrl, @JsonProperty(value="error") JsonNullable<? extends VerificationOauthVerificationError> error, @JsonProperty(value="expire_at") long expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        this.error = error;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Oauth(VerificationOauthVerificationStatus status, String strategy, long expireAt) {
        this(Optional.empty(), status, strategy, Optional.empty(), (JsonNullable<? extends VerificationOauthVerificationError>)JsonNullable.undefined(), expireAt, Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationOauthVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<String> externalVerificationRedirectUrl() {
        return this.externalVerificationRedirectUrl;
    }

    @JsonIgnore
    public JsonNullable<VerificationOauthVerificationError> error() {
        return this.error;
    }

    @JsonIgnore
    public long expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Oauth withObject(VerificationOauthVerificationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public Oauth withObject(Optional<? extends VerificationOauthVerificationObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Oauth withStatus(VerificationOauthVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Oauth withStrategy(String strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Oauth withExternalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = Optional.ofNullable(externalVerificationRedirectUrl);
        return this;
    }

    public Oauth withExternalVerificationRedirectUrl(Optional<String> externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        return this;
    }

    public Oauth withError(VerificationOauthVerificationError error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public Oauth withError(JsonNullable<? extends VerificationOauthVerificationError> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public Oauth withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Oauth withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Oauth withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Oauth withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Oauth withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Oauth other = (Oauth)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals(this.status, other.status) && Utils.enhancedDeepEquals(this.strategy, other.strategy) && Utils.enhancedDeepEquals(this.externalVerificationRedirectUrl, other.externalVerificationRedirectUrl) && Utils.enhancedDeepEquals(this.error, other.error) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
    }

    public String toString() {
        return Utils.toString(Oauth.class, "object", this.object, "status", this.status, "strategy", this.strategy, "externalVerificationRedirectUrl", this.externalVerificationRedirectUrl, "error", this.error, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient);
    }

    public static final class Builder {
        private Optional<? extends VerificationOauthVerificationObject> object = Optional.empty();
        private VerificationOauthVerificationStatus status;
        private String strategy;
        private Optional<String> externalVerificationRedirectUrl = Optional.empty();
        private JsonNullable<? extends VerificationOauthVerificationError> error = JsonNullable.undefined();
        private Long expireAt;
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationOauthVerificationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationOauthVerificationObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationOauthVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(String strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder externalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = Optional.ofNullable(externalVerificationRedirectUrl);
            return this;
        }

        public Builder externalVerificationRedirectUrl(Optional<String> externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
            return this;
        }

        public Builder error(VerificationOauthVerificationError error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends VerificationOauthVerificationError> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Oauth build() {
            return new Oauth(this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
        }
    }
}

