/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationDomain;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class OrganizationDomains {
    @JsonProperty(value="data")
    private List<OrganizationDomain> data;
    @JsonProperty(value="total_count")
    private long totalCount;

    @JsonCreator
    public OrganizationDomains(@JsonProperty(value="data") List<OrganizationDomain> data, @JsonProperty(value="total_count") long totalCount) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(totalCount, "totalCount");
        this.data = data;
        this.totalCount = totalCount;
    }

    @JsonIgnore
    public List<OrganizationDomain> data() {
        return this.data;
    }

    @JsonIgnore
    public long totalCount() {
        return this.totalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public OrganizationDomains withData(List<OrganizationDomain> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public OrganizationDomains withTotalCount(long totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationDomains other = (OrganizationDomains)o;
        return Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.totalCount, other.totalCount);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.data, this.totalCount);
    }

    public String toString() {
        return Utils.toString(OrganizationDomains.class, "data", this.data, "totalCount", this.totalCount);
    }

    public static final class Builder {
        private List<OrganizationDomain> data;
        private Long totalCount;

        private Builder() {
        }

        public Builder data(List<OrganizationDomain> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder totalCount(long totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public OrganizationDomains build() {
            return new OrganizationDomains(this.data, this.totalCount);
        }
    }
}

