/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceSubscriptionItem;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class PaginatedCommerceSubscriptionItemResponse {
    @JsonProperty(value="data")
    private List<CommerceSubscriptionItem> data;
    @JsonProperty(value="total_count")
    private long totalCount;

    @JsonCreator
    public PaginatedCommerceSubscriptionItemResponse(@JsonProperty(value="data") List<CommerceSubscriptionItem> data, @JsonProperty(value="total_count") long totalCount) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(totalCount, "totalCount");
        this.data = data;
        this.totalCount = totalCount;
    }

    @JsonIgnore
    public List<CommerceSubscriptionItem> data() {
        return this.data;
    }

    @JsonIgnore
    public long totalCount() {
        return this.totalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PaginatedCommerceSubscriptionItemResponse withData(List<CommerceSubscriptionItem> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public PaginatedCommerceSubscriptionItemResponse withTotalCount(long totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedCommerceSubscriptionItemResponse other = (PaginatedCommerceSubscriptionItemResponse)o;
        return Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.totalCount, other.totalCount);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.data, this.totalCount);
    }

    public String toString() {
        return Utils.toString(PaginatedCommerceSubscriptionItemResponse.class, "data", this.data, "totalCount", this.totalCount);
    }

    public static final class Builder {
        private List<CommerceSubscriptionItem> data;
        private Long totalCount;

        private Builder() {
        }

        public Builder data(List<CommerceSubscriptionItem> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder totalCount(long totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public PaginatedCommerceSubscriptionItemResponse build() {
            return new PaginatedCommerceSubscriptionItemResponse(this.data, this.totalCount);
        }
    }
}

