/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.PasskeyObject;
import com.clerk.backend_api.models.components.PasskeyVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class Passkey {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonProperty(value="object")
    private PasskeyObject object;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="last_used_at")
    private long lastUsedAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends PasskeyVerification> verification;

    @JsonCreator
    public Passkey(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") PasskeyObject object, @JsonProperty(value="name") String name, @JsonProperty(value="last_used_at") long lastUsedAt, @JsonProperty(value="verification") Optional<? extends PasskeyVerification> verification) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        Utils.checkNotNull(verification, "verification");
        this.id = id;
        this.object = object;
        this.name = name;
        this.lastUsedAt = lastUsedAt;
        this.verification = verification;
    }

    public Passkey(PasskeyObject object, String name, long lastUsedAt) {
        this(Optional.empty(), object, name, lastUsedAt, Optional.empty());
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public PasskeyObject object() {
        return this.object;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public long lastUsedAt() {
        return this.lastUsedAt;
    }

    @JsonIgnore
    public Optional<PasskeyVerification> verification() {
        return this.verification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Passkey withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public Passkey withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Passkey withObject(PasskeyObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Passkey withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Passkey withLastUsedAt(long lastUsedAt) {
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        this.lastUsedAt = lastUsedAt;
        return this;
    }

    public Passkey withVerification(PasskeyVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public Passkey withVerification(Optional<? extends PasskeyVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Passkey other = (Passkey)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.lastUsedAt, other.lastUsedAt) && Utils.enhancedDeepEquals(this.verification, other.verification);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.id, this.object, this.name, this.lastUsedAt, this.verification});
    }

    public String toString() {
        return Utils.toString(Passkey.class, new Object[]{"id", this.id, "object", this.object, "name", this.name, "lastUsedAt", this.lastUsedAt, "verification", this.verification});
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private PasskeyObject object;
        private String name;
        private Long lastUsedAt;
        private Optional<? extends PasskeyVerification> verification = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(PasskeyObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder lastUsedAt(long lastUsedAt) {
            Utils.checkNotNull(lastUsedAt, "lastUsedAt");
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        public Builder verification(PasskeyVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends PasskeyVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Passkey build() {
            return new Passkey(this.id, this.object, this.name, this.lastUsedAt, this.verification);
        }
    }
}

