/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceSubscriptionItemPayerObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class Payer {
    @JsonProperty(value="object")
    private CommerceSubscriptionItemPayerObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="user_id")
    private Optional<String> userId;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="email")
    private String email;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="organization_id")
    private Optional<String> organizationId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="organization_name")
    private Optional<String> organizationName;
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public Payer(@JsonProperty(value="object") CommerceSubscriptionItemPayerObject object, @JsonProperty(value="id") String id, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="user_id") Optional<String> userId, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="organization_id") Optional<String> organizationId, @JsonProperty(value="organization_name") Optional<String> organizationName, @JsonProperty(value="image_url") String imageUrl, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(organizationName, "organizationName");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.instanceId = instanceId;
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.imageUrl = imageUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Payer(CommerceSubscriptionItemPayerObject object, String id, String instanceId, String firstName, String lastName, String email, String imageUrl, long createdAt, long updatedAt) {
        this(object, id, instanceId, Optional.empty(), firstName, lastName, email, Optional.empty(), Optional.empty(), imageUrl, createdAt, updatedAt);
    }

    @JsonIgnore
    public CommerceSubscriptionItemPayerObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public Optional<String> userId() {
        return this.userId;
    }

    @JsonIgnore
    public String firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public String lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String email() {
        return this.email;
    }

    @JsonIgnore
    public Optional<String> organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<String> organizationName() {
        return this.organizationName;
    }

    @JsonIgnore
    public String imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Payer withObject(CommerceSubscriptionItemPayerObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Payer withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Payer withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public Payer withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = Optional.ofNullable(userId);
        return this;
    }

    public Payer withUserId(Optional<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public Payer withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public Payer withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public Payer withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public Payer withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = Optional.ofNullable(organizationId);
        return this;
    }

    public Payer withOrganizationId(Optional<String> organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public Payer withOrganizationName(String organizationName) {
        Utils.checkNotNull(organizationName, "organizationName");
        this.organizationName = Optional.ofNullable(organizationName);
        return this;
    }

    public Payer withOrganizationName(Optional<String> organizationName) {
        Utils.checkNotNull(organizationName, "organizationName");
        this.organizationName = organizationName;
        return this;
    }

    public Payer withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public Payer withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public Payer withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payer other = (Payer)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.instanceId, other.instanceId) && Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.firstName, other.firstName) && Utils.enhancedDeepEquals(this.lastName, other.lastName) && Utils.enhancedDeepEquals(this.email, other.email) && Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.organizationName, other.organizationName) && Utils.enhancedDeepEquals(this.imageUrl, other.imageUrl) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.instanceId, this.userId, this.firstName, this.lastName, this.email, this.organizationId, this.organizationName, this.imageUrl, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(Payer.class, new Object[]{"object", this.object, "id", this.id, "instanceId", this.instanceId, "userId", this.userId, "firstName", this.firstName, "lastName", this.lastName, "email", this.email, "organizationId", this.organizationId, "organizationName", this.organizationName, "imageUrl", this.imageUrl, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private CommerceSubscriptionItemPayerObject object;
        private String id;
        private String instanceId;
        private Optional<String> userId = Optional.empty();
        private String firstName;
        private String lastName;
        private String email;
        private Optional<String> organizationId = Optional.empty();
        private Optional<String> organizationName = Optional.empty();
        private String imageUrl;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(CommerceSubscriptionItemPayerObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public Builder userId(Optional<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = Optional.ofNullable(organizationId);
            return this;
        }

        public Builder organizationId(Optional<String> organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder organizationName(String organizationName) {
            Utils.checkNotNull(organizationName, "organizationName");
            this.organizationName = Optional.ofNullable(organizationName);
            return this;
        }

        public Builder organizationName(Optional<String> organizationName) {
            Utils.checkNotNull(organizationName, "organizationName");
            this.organizationName = organizationName;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Payer build() {
            return new Payer(this.object, this.id, this.instanceId, this.userId, this.firstName, this.lastName, this.email, this.organizationId, this.organizationName, this.imageUrl, this.createdAt, this.updatedAt);
        }
    }
}

