/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public enum PaymentMethod {
    CARD("card"),
    APPLE_PAY("apple_pay"),
    GOOGLE_PAY("google_pay");

    @JsonValue
    private final String value;

    private PaymentMethod(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static Optional<PaymentMethod> fromValue(String value) {
        for (PaymentMethod o : PaymentMethod.values()) {
            if (!Objects.deepEquals(o.value, value)) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }
}

