/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CommerceMoneyResponse;
import com.clerk.backend_api.models.components.CommerceSubscriptionItemPlanObject;
import com.clerk.backend_api.models.components.FeatureResponse;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Plan {
    @JsonProperty(value="object")
    private CommerceSubscriptionItemPlanObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="fee")
    private CommerceMoneyResponse fee;
    @JsonProperty(value="annual_monthly_fee")
    private CommerceMoneyResponse annualMonthlyFee;
    @JsonProperty(value="annual_fee")
    private CommerceMoneyResponse annualFee;
    @JsonProperty(value="amount")
    private long amount;
    @JsonProperty(value="amount_formatted")
    private String amountFormatted;
    @JsonProperty(value="annual_monthly_amount")
    private long annualMonthlyAmount;
    @JsonProperty(value="annual_monthly_amount_formatted")
    private String annualMonthlyAmountFormatted;
    @JsonProperty(value="annual_amount")
    private long annualAmount;
    @JsonProperty(value="annual_amount_formatted")
    private String annualAmountFormatted;
    @JsonProperty(value="currency_symbol")
    private String currencySymbol;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="product_id")
    private String productId;
    @JsonProperty(value="is_default")
    private boolean isDefault;
    @JsonProperty(value="is_recurring")
    private boolean isRecurring;
    @JsonProperty(value="publicly_visible")
    private boolean publiclyVisible;
    @JsonProperty(value="has_base_fee")
    private boolean hasBaseFee;
    @JsonProperty(value="payer_type")
    private List<String> payerType;
    @JsonProperty(value="for_payer_type")
    private String forPayerType;
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="avatar_url")
    private String avatarUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="period")
    private Optional<String> period;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="interval")
    private Optional<Long> interval;
    @JsonProperty(value="features")
    private List<FeatureResponse> features;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="free_trial_enabled")
    private Optional<Boolean> freeTrialEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="free_trial_days")
    private JsonNullable<Long> freeTrialDays;

    @JsonCreator
    public Plan(@JsonProperty(value="object") CommerceSubscriptionItemPlanObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fee") CommerceMoneyResponse fee, @JsonProperty(value="annual_monthly_fee") CommerceMoneyResponse annualMonthlyFee, @JsonProperty(value="annual_fee") CommerceMoneyResponse annualFee, @JsonProperty(value="amount") long amount, @JsonProperty(value="amount_formatted") String amountFormatted, @JsonProperty(value="annual_monthly_amount") long annualMonthlyAmount, @JsonProperty(value="annual_monthly_amount_formatted") String annualMonthlyAmountFormatted, @JsonProperty(value="annual_amount") long annualAmount, @JsonProperty(value="annual_amount_formatted") String annualAmountFormatted, @JsonProperty(value="currency_symbol") String currencySymbol, @JsonProperty(value="currency") String currency, @JsonProperty(value="description") String description, @JsonProperty(value="product_id") String productId, @JsonProperty(value="is_default") boolean isDefault, @JsonProperty(value="is_recurring") boolean isRecurring, @JsonProperty(value="publicly_visible") boolean publiclyVisible, @JsonProperty(value="has_base_fee") boolean hasBaseFee, @JsonProperty(value="payer_type") List<String> payerType, @JsonProperty(value="for_payer_type") String forPayerType, @JsonProperty(value="slug") String slug, @JsonProperty(value="avatar_url") String avatarUrl, @JsonProperty(value="period") Optional<String> period, @JsonProperty(value="interval") Optional<Long> interval, @JsonProperty(value="features") List<FeatureResponse> features, @JsonProperty(value="free_trial_enabled") Optional<Boolean> freeTrialEnabled, @JsonProperty(value="free_trial_days") JsonNullable<Long> freeTrialDays) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(fee, "fee");
        Utils.checkNotNull(annualMonthlyFee, "annualMonthlyFee");
        Utils.checkNotNull(annualFee, "annualFee");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(amountFormatted, "amountFormatted");
        Utils.checkNotNull(annualMonthlyAmount, "annualMonthlyAmount");
        Utils.checkNotNull(annualMonthlyAmountFormatted, "annualMonthlyAmountFormatted");
        Utils.checkNotNull(annualAmount, "annualAmount");
        Utils.checkNotNull(annualAmountFormatted, "annualAmountFormatted");
        Utils.checkNotNull(currencySymbol, "currencySymbol");
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(productId, "productId");
        Utils.checkNotNull(isDefault, "isDefault");
        Utils.checkNotNull(isRecurring, "isRecurring");
        Utils.checkNotNull(publiclyVisible, "publiclyVisible");
        Utils.checkNotNull(hasBaseFee, "hasBaseFee");
        Utils.checkNotNull(payerType, "payerType");
        Utils.checkNotNull(forPayerType, "forPayerType");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(avatarUrl, "avatarUrl");
        Utils.checkNotNull(period, "period");
        Utils.checkNotNull(interval, "interval");
        Utils.checkNotNull(features, "features");
        Utils.checkNotNull(freeTrialEnabled, "freeTrialEnabled");
        Utils.checkNotNull(freeTrialDays, "freeTrialDays");
        this.object = object;
        this.id = id;
        this.name = name;
        this.fee = fee;
        this.annualMonthlyFee = annualMonthlyFee;
        this.annualFee = annualFee;
        this.amount = amount;
        this.amountFormatted = amountFormatted;
        this.annualMonthlyAmount = annualMonthlyAmount;
        this.annualMonthlyAmountFormatted = annualMonthlyAmountFormatted;
        this.annualAmount = annualAmount;
        this.annualAmountFormatted = annualAmountFormatted;
        this.currencySymbol = currencySymbol;
        this.currency = currency;
        this.description = description;
        this.productId = productId;
        this.isDefault = isDefault;
        this.isRecurring = isRecurring;
        this.publiclyVisible = publiclyVisible;
        this.hasBaseFee = hasBaseFee;
        this.payerType = payerType;
        this.forPayerType = forPayerType;
        this.slug = slug;
        this.avatarUrl = avatarUrl;
        this.period = period;
        this.interval = interval;
        this.features = features;
        this.freeTrialEnabled = freeTrialEnabled;
        this.freeTrialDays = freeTrialDays;
    }

    public Plan(CommerceSubscriptionItemPlanObject object, String id, String name, CommerceMoneyResponse fee, CommerceMoneyResponse annualMonthlyFee, CommerceMoneyResponse annualFee, long amount, String amountFormatted, long annualMonthlyAmount, String annualMonthlyAmountFormatted, long annualAmount, String annualAmountFormatted, String currencySymbol, String currency, String description, String productId, boolean isDefault, boolean isRecurring, boolean publiclyVisible, boolean hasBaseFee, List<String> payerType, String forPayerType, String slug, String avatarUrl, List<FeatureResponse> features) {
        this(object, id, name, fee, annualMonthlyFee, annualFee, amount, amountFormatted, annualMonthlyAmount, annualMonthlyAmountFormatted, annualAmount, annualAmountFormatted, currencySymbol, currency, description, productId, isDefault, isRecurring, publiclyVisible, hasBaseFee, payerType, forPayerType, slug, avatarUrl, Optional.empty(), Optional.empty(), features, Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined());
    }

    @JsonIgnore
    public CommerceSubscriptionItemPlanObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public CommerceMoneyResponse fee() {
        return this.fee;
    }

    @JsonIgnore
    public CommerceMoneyResponse annualMonthlyFee() {
        return this.annualMonthlyFee;
    }

    @JsonIgnore
    public CommerceMoneyResponse annualFee() {
        return this.annualFee;
    }

    @JsonIgnore
    public long amount() {
        return this.amount;
    }

    @JsonIgnore
    public String amountFormatted() {
        return this.amountFormatted;
    }

    @JsonIgnore
    public long annualMonthlyAmount() {
        return this.annualMonthlyAmount;
    }

    @JsonIgnore
    public String annualMonthlyAmountFormatted() {
        return this.annualMonthlyAmountFormatted;
    }

    @JsonIgnore
    public long annualAmount() {
        return this.annualAmount;
    }

    @JsonIgnore
    public String annualAmountFormatted() {
        return this.annualAmountFormatted;
    }

    @JsonIgnore
    public String currencySymbol() {
        return this.currencySymbol;
    }

    @JsonIgnore
    public String currency() {
        return this.currency;
    }

    @JsonIgnore
    public String description() {
        return this.description;
    }

    @JsonIgnore
    public String productId() {
        return this.productId;
    }

    @JsonIgnore
    public boolean isDefault() {
        return this.isDefault;
    }

    @JsonIgnore
    public boolean isRecurring() {
        return this.isRecurring;
    }

    @JsonIgnore
    public boolean publiclyVisible() {
        return this.publiclyVisible;
    }

    @JsonIgnore
    public boolean hasBaseFee() {
        return this.hasBaseFee;
    }

    @JsonIgnore
    public List<String> payerType() {
        return this.payerType;
    }

    @JsonIgnore
    public String forPayerType() {
        return this.forPayerType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public String avatarUrl() {
        return this.avatarUrl;
    }

    @JsonIgnore
    public Optional<String> period() {
        return this.period;
    }

    @JsonIgnore
    public Optional<Long> interval() {
        return this.interval;
    }

    @JsonIgnore
    public List<FeatureResponse> features() {
        return this.features;
    }

    @JsonIgnore
    public Optional<Boolean> freeTrialEnabled() {
        return this.freeTrialEnabled;
    }

    @JsonIgnore
    public JsonNullable<Long> freeTrialDays() {
        return this.freeTrialDays;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Plan withObject(CommerceSubscriptionItemPlanObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Plan withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Plan withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Plan withFee(CommerceMoneyResponse fee) {
        Utils.checkNotNull(fee, "fee");
        this.fee = fee;
        return this;
    }

    public Plan withAnnualMonthlyFee(CommerceMoneyResponse annualMonthlyFee) {
        Utils.checkNotNull(annualMonthlyFee, "annualMonthlyFee");
        this.annualMonthlyFee = annualMonthlyFee;
        return this;
    }

    public Plan withAnnualFee(CommerceMoneyResponse annualFee) {
        Utils.checkNotNull(annualFee, "annualFee");
        this.annualFee = annualFee;
        return this;
    }

    public Plan withAmount(long amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public Plan withAmountFormatted(String amountFormatted) {
        Utils.checkNotNull(amountFormatted, "amountFormatted");
        this.amountFormatted = amountFormatted;
        return this;
    }

    public Plan withAnnualMonthlyAmount(long annualMonthlyAmount) {
        Utils.checkNotNull(annualMonthlyAmount, "annualMonthlyAmount");
        this.annualMonthlyAmount = annualMonthlyAmount;
        return this;
    }

    public Plan withAnnualMonthlyAmountFormatted(String annualMonthlyAmountFormatted) {
        Utils.checkNotNull(annualMonthlyAmountFormatted, "annualMonthlyAmountFormatted");
        this.annualMonthlyAmountFormatted = annualMonthlyAmountFormatted;
        return this;
    }

    public Plan withAnnualAmount(long annualAmount) {
        Utils.checkNotNull(annualAmount, "annualAmount");
        this.annualAmount = annualAmount;
        return this;
    }

    public Plan withAnnualAmountFormatted(String annualAmountFormatted) {
        Utils.checkNotNull(annualAmountFormatted, "annualAmountFormatted");
        this.annualAmountFormatted = annualAmountFormatted;
        return this;
    }

    public Plan withCurrencySymbol(String currencySymbol) {
        Utils.checkNotNull(currencySymbol, "currencySymbol");
        this.currencySymbol = currencySymbol;
        return this;
    }

    public Plan withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    public Plan withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public Plan withProductId(String productId) {
        Utils.checkNotNull(productId, "productId");
        this.productId = productId;
        return this;
    }

    public Plan withIsDefault(boolean isDefault) {
        Utils.checkNotNull(isDefault, "isDefault");
        this.isDefault = isDefault;
        return this;
    }

    public Plan withIsRecurring(boolean isRecurring) {
        Utils.checkNotNull(isRecurring, "isRecurring");
        this.isRecurring = isRecurring;
        return this;
    }

    public Plan withPubliclyVisible(boolean publiclyVisible) {
        Utils.checkNotNull(publiclyVisible, "publiclyVisible");
        this.publiclyVisible = publiclyVisible;
        return this;
    }

    public Plan withHasBaseFee(boolean hasBaseFee) {
        Utils.checkNotNull(hasBaseFee, "hasBaseFee");
        this.hasBaseFee = hasBaseFee;
        return this;
    }

    public Plan withPayerType(List<String> payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = payerType;
        return this;
    }

    public Plan withForPayerType(String forPayerType) {
        Utils.checkNotNull(forPayerType, "forPayerType");
        this.forPayerType = forPayerType;
        return this;
    }

    public Plan withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public Plan withAvatarUrl(String avatarUrl) {
        Utils.checkNotNull(avatarUrl, "avatarUrl");
        this.avatarUrl = avatarUrl;
        return this;
    }

    public Plan withPeriod(String period) {
        Utils.checkNotNull(period, "period");
        this.period = Optional.ofNullable(period);
        return this;
    }

    public Plan withPeriod(Optional<String> period) {
        Utils.checkNotNull(period, "period");
        this.period = period;
        return this;
    }

    public Plan withInterval(long interval) {
        Utils.checkNotNull(interval, "interval");
        this.interval = Optional.ofNullable(interval);
        return this;
    }

    public Plan withInterval(Optional<Long> interval) {
        Utils.checkNotNull(interval, "interval");
        this.interval = interval;
        return this;
    }

    public Plan withFeatures(List<FeatureResponse> features) {
        Utils.checkNotNull(features, "features");
        this.features = features;
        return this;
    }

    public Plan withFreeTrialEnabled(boolean freeTrialEnabled) {
        Utils.checkNotNull(freeTrialEnabled, "freeTrialEnabled");
        this.freeTrialEnabled = Optional.ofNullable(freeTrialEnabled);
        return this;
    }

    public Plan withFreeTrialEnabled(Optional<Boolean> freeTrialEnabled) {
        Utils.checkNotNull(freeTrialEnabled, "freeTrialEnabled");
        this.freeTrialEnabled = freeTrialEnabled;
        return this;
    }

    public Plan withFreeTrialDays(long freeTrialDays) {
        Utils.checkNotNull(freeTrialDays, "freeTrialDays");
        this.freeTrialDays = JsonNullable.of((Object)freeTrialDays);
        return this;
    }

    public Plan withFreeTrialDays(JsonNullable<Long> freeTrialDays) {
        Utils.checkNotNull(freeTrialDays, "freeTrialDays");
        this.freeTrialDays = freeTrialDays;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan other = (Plan)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.fee, other.fee) && Utils.enhancedDeepEquals(this.annualMonthlyFee, other.annualMonthlyFee) && Utils.enhancedDeepEquals(this.annualFee, other.annualFee) && Utils.enhancedDeepEquals(this.amount, other.amount) && Utils.enhancedDeepEquals(this.amountFormatted, other.amountFormatted) && Utils.enhancedDeepEquals(this.annualMonthlyAmount, other.annualMonthlyAmount) && Utils.enhancedDeepEquals(this.annualMonthlyAmountFormatted, other.annualMonthlyAmountFormatted) && Utils.enhancedDeepEquals(this.annualAmount, other.annualAmount) && Utils.enhancedDeepEquals(this.annualAmountFormatted, other.annualAmountFormatted) && Utils.enhancedDeepEquals(this.currencySymbol, other.currencySymbol) && Utils.enhancedDeepEquals(this.currency, other.currency) && Utils.enhancedDeepEquals(this.description, other.description) && Utils.enhancedDeepEquals(this.productId, other.productId) && Utils.enhancedDeepEquals(this.isDefault, other.isDefault) && Utils.enhancedDeepEquals(this.isRecurring, other.isRecurring) && Utils.enhancedDeepEquals(this.publiclyVisible, other.publiclyVisible) && Utils.enhancedDeepEquals(this.hasBaseFee, other.hasBaseFee) && Utils.enhancedDeepEquals(this.payerType, other.payerType) && Utils.enhancedDeepEquals(this.forPayerType, other.forPayerType) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.avatarUrl, other.avatarUrl) && Utils.enhancedDeepEquals(this.period, other.period) && Utils.enhancedDeepEquals(this.interval, other.interval) && Utils.enhancedDeepEquals(this.features, other.features) && Utils.enhancedDeepEquals(this.freeTrialEnabled, other.freeTrialEnabled) && Utils.enhancedDeepEquals(this.freeTrialDays, other.freeTrialDays);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.name, this.fee, this.annualMonthlyFee, this.annualFee, this.amount, this.amountFormatted, this.annualMonthlyAmount, this.annualMonthlyAmountFormatted, this.annualAmount, this.annualAmountFormatted, this.currencySymbol, this.currency, this.description, this.productId, this.isDefault, this.isRecurring, this.publiclyVisible, this.hasBaseFee, this.payerType, this.forPayerType, this.slug, this.avatarUrl, this.period, this.interval, this.features, this.freeTrialEnabled, this.freeTrialDays});
    }

    public String toString() {
        return Utils.toString(Plan.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "fee", this.fee, "annualMonthlyFee", this.annualMonthlyFee, "annualFee", this.annualFee, "amount", this.amount, "amountFormatted", this.amountFormatted, "annualMonthlyAmount", this.annualMonthlyAmount, "annualMonthlyAmountFormatted", this.annualMonthlyAmountFormatted, "annualAmount", this.annualAmount, "annualAmountFormatted", this.annualAmountFormatted, "currencySymbol", this.currencySymbol, "currency", this.currency, "description", this.description, "productId", this.productId, "isDefault", this.isDefault, "isRecurring", this.isRecurring, "publiclyVisible", this.publiclyVisible, "hasBaseFee", this.hasBaseFee, "payerType", this.payerType, "forPayerType", this.forPayerType, "slug", this.slug, "avatarUrl", this.avatarUrl, "period", this.period, "interval", this.interval, "features", this.features, "freeTrialEnabled", this.freeTrialEnabled, "freeTrialDays", this.freeTrialDays});
    }

    public static final class Builder {
        private CommerceSubscriptionItemPlanObject object;
        private String id;
        private String name;
        private CommerceMoneyResponse fee;
        private CommerceMoneyResponse annualMonthlyFee;
        private CommerceMoneyResponse annualFee;
        private Long amount;
        private String amountFormatted;
        private Long annualMonthlyAmount;
        private String annualMonthlyAmountFormatted;
        private Long annualAmount;
        private String annualAmountFormatted;
        private String currencySymbol;
        private String currency;
        private String description;
        private String productId;
        private Boolean isDefault;
        private Boolean isRecurring;
        private Boolean publiclyVisible;
        private Boolean hasBaseFee;
        private List<String> payerType;
        private String forPayerType;
        private String slug;
        private String avatarUrl;
        private Optional<String> period = Optional.empty();
        private Optional<Long> interval = Optional.empty();
        private List<FeatureResponse> features;
        private Optional<Boolean> freeTrialEnabled = Optional.empty();
        private JsonNullable<Long> freeTrialDays = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(CommerceSubscriptionItemPlanObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder fee(CommerceMoneyResponse fee) {
            Utils.checkNotNull(fee, "fee");
            this.fee = fee;
            return this;
        }

        public Builder annualMonthlyFee(CommerceMoneyResponse annualMonthlyFee) {
            Utils.checkNotNull(annualMonthlyFee, "annualMonthlyFee");
            this.annualMonthlyFee = annualMonthlyFee;
            return this;
        }

        public Builder annualFee(CommerceMoneyResponse annualFee) {
            Utils.checkNotNull(annualFee, "annualFee");
            this.annualFee = annualFee;
            return this;
        }

        public Builder amount(long amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder amountFormatted(String amountFormatted) {
            Utils.checkNotNull(amountFormatted, "amountFormatted");
            this.amountFormatted = amountFormatted;
            return this;
        }

        public Builder annualMonthlyAmount(long annualMonthlyAmount) {
            Utils.checkNotNull(annualMonthlyAmount, "annualMonthlyAmount");
            this.annualMonthlyAmount = annualMonthlyAmount;
            return this;
        }

        public Builder annualMonthlyAmountFormatted(String annualMonthlyAmountFormatted) {
            Utils.checkNotNull(annualMonthlyAmountFormatted, "annualMonthlyAmountFormatted");
            this.annualMonthlyAmountFormatted = annualMonthlyAmountFormatted;
            return this;
        }

        public Builder annualAmount(long annualAmount) {
            Utils.checkNotNull(annualAmount, "annualAmount");
            this.annualAmount = annualAmount;
            return this;
        }

        public Builder annualAmountFormatted(String annualAmountFormatted) {
            Utils.checkNotNull(annualAmountFormatted, "annualAmountFormatted");
            this.annualAmountFormatted = annualAmountFormatted;
            return this;
        }

        public Builder currencySymbol(String currencySymbol) {
            Utils.checkNotNull(currencySymbol, "currencySymbol");
            this.currencySymbol = currencySymbol;
            return this;
        }

        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder productId(String productId) {
            Utils.checkNotNull(productId, "productId");
            this.productId = productId;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            Utils.checkNotNull(isDefault, "isDefault");
            this.isDefault = isDefault;
            return this;
        }

        public Builder isRecurring(boolean isRecurring) {
            Utils.checkNotNull(isRecurring, "isRecurring");
            this.isRecurring = isRecurring;
            return this;
        }

        public Builder publiclyVisible(boolean publiclyVisible) {
            Utils.checkNotNull(publiclyVisible, "publiclyVisible");
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        public Builder hasBaseFee(boolean hasBaseFee) {
            Utils.checkNotNull(hasBaseFee, "hasBaseFee");
            this.hasBaseFee = hasBaseFee;
            return this;
        }

        public Builder payerType(List<String> payerType) {
            Utils.checkNotNull(payerType, "payerType");
            this.payerType = payerType;
            return this;
        }

        public Builder forPayerType(String forPayerType) {
            Utils.checkNotNull(forPayerType, "forPayerType");
            this.forPayerType = forPayerType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder avatarUrl(String avatarUrl) {
            Utils.checkNotNull(avatarUrl, "avatarUrl");
            this.avatarUrl = avatarUrl;
            return this;
        }

        public Builder period(String period) {
            Utils.checkNotNull(period, "period");
            this.period = Optional.ofNullable(period);
            return this;
        }

        public Builder period(Optional<String> period) {
            Utils.checkNotNull(period, "period");
            this.period = period;
            return this;
        }

        public Builder interval(long interval) {
            Utils.checkNotNull(interval, "interval");
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        public Builder interval(Optional<Long> interval) {
            Utils.checkNotNull(interval, "interval");
            this.interval = interval;
            return this;
        }

        public Builder features(List<FeatureResponse> features) {
            Utils.checkNotNull(features, "features");
            this.features = features;
            return this;
        }

        public Builder freeTrialEnabled(boolean freeTrialEnabled) {
            Utils.checkNotNull(freeTrialEnabled, "freeTrialEnabled");
            this.freeTrialEnabled = Optional.ofNullable(freeTrialEnabled);
            return this;
        }

        public Builder freeTrialEnabled(Optional<Boolean> freeTrialEnabled) {
            Utils.checkNotNull(freeTrialEnabled, "freeTrialEnabled");
            this.freeTrialEnabled = freeTrialEnabled;
            return this;
        }

        public Builder freeTrialDays(long freeTrialDays) {
            Utils.checkNotNull(freeTrialDays, "freeTrialDays");
            this.freeTrialDays = JsonNullable.of((Object)freeTrialDays);
            return this;
        }

        public Builder freeTrialDays(JsonNullable<Long> freeTrialDays) {
            Utils.checkNotNull(freeTrialDays, "freeTrialDays");
            this.freeTrialDays = freeTrialDays;
            return this;
        }

        public Plan build() {
            return new Plan(this.object, this.id, this.name, this.fee, this.annualMonthlyFee, this.annualFee, this.amount, this.amountFormatted, this.annualMonthlyAmount, this.annualMonthlyAmountFormatted, this.annualAmount, this.annualAmountFormatted, this.currencySymbol, this.currency, this.description, this.productId, this.isDefault, this.isRecurring, this.publiclyVisible, this.hasBaseFee, this.payerType, this.forPayerType, this.slug, this.avatarUrl, this.period, this.interval, this.features, this.freeTrialEnabled, this.freeTrialDays);
        }
    }
}

