/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ProxyCheckObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class ProxyCheck {
    @JsonProperty(value="object")
    private ProxyCheckObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="domain_id")
    private String domainId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_run_at")
    private Optional<Long> lastRunAt;
    @JsonProperty(value="proxy_url")
    private String proxyUrl;
    @JsonProperty(value="successful")
    private boolean successful;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public ProxyCheck(@JsonProperty(value="object") ProxyCheckObject object, @JsonProperty(value="id") String id, @JsonProperty(value="domain_id") String domainId, @JsonProperty(value="last_run_at") Optional<Long> lastRunAt, @JsonProperty(value="proxy_url") String proxyUrl, @JsonProperty(value="successful") boolean successful, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(domainId, "domainId");
        Utils.checkNotNull(lastRunAt, "lastRunAt");
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        Utils.checkNotNull(successful, "successful");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.domainId = domainId;
        this.lastRunAt = lastRunAt;
        this.proxyUrl = proxyUrl;
        this.successful = successful;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public ProxyCheck(ProxyCheckObject object, String id, String domainId, String proxyUrl, boolean successful, long createdAt, long updatedAt) {
        this(object, id, domainId, Optional.empty(), proxyUrl, successful, createdAt, updatedAt);
    }

    @JsonIgnore
    public ProxyCheckObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String domainId() {
        return this.domainId;
    }

    @JsonIgnore
    public Optional<Long> lastRunAt() {
        return this.lastRunAt;
    }

    @JsonIgnore
    public String proxyUrl() {
        return this.proxyUrl;
    }

    @JsonIgnore
    public boolean successful() {
        return this.successful;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ProxyCheck withObject(ProxyCheckObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public ProxyCheck withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public ProxyCheck withDomainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public ProxyCheck withLastRunAt(long lastRunAt) {
        Utils.checkNotNull(lastRunAt, "lastRunAt");
        this.lastRunAt = Optional.ofNullable(lastRunAt);
        return this;
    }

    public ProxyCheck withLastRunAt(Optional<Long> lastRunAt) {
        Utils.checkNotNull(lastRunAt, "lastRunAt");
        this.lastRunAt = lastRunAt;
        return this;
    }

    public ProxyCheck withProxyUrl(String proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = proxyUrl;
        return this;
    }

    public ProxyCheck withSuccessful(boolean successful) {
        Utils.checkNotNull(successful, "successful");
        this.successful = successful;
        return this;
    }

    public ProxyCheck withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public ProxyCheck withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyCheck other = (ProxyCheck)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.domainId, other.domainId) && Utils.enhancedDeepEquals(this.lastRunAt, other.lastRunAt) && Utils.enhancedDeepEquals(this.proxyUrl, other.proxyUrl) && Utils.enhancedDeepEquals(this.successful, other.successful) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.domainId, this.lastRunAt, this.proxyUrl, this.successful, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(ProxyCheck.class, new Object[]{"object", this.object, "id", this.id, "domainId", this.domainId, "lastRunAt", this.lastRunAt, "proxyUrl", this.proxyUrl, "successful", this.successful, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private ProxyCheckObject object;
        private String id;
        private String domainId;
        private Optional<Long> lastRunAt = Optional.empty();
        private String proxyUrl;
        private Boolean successful;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(ProxyCheckObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder domainId(String domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = domainId;
            return this;
        }

        public Builder lastRunAt(long lastRunAt) {
            Utils.checkNotNull(lastRunAt, "lastRunAt");
            this.lastRunAt = Optional.ofNullable(lastRunAt);
            return this;
        }

        public Builder lastRunAt(Optional<Long> lastRunAt) {
            Utils.checkNotNull(lastRunAt, "lastRunAt");
            this.lastRunAt = lastRunAt;
            return this;
        }

        public Builder proxyUrl(String proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = proxyUrl;
            return this;
        }

        public Builder successful(boolean successful) {
            Utils.checkNotNull(successful, "successful");
            this.successful = successful;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public ProxyCheck build() {
            return new ProxyCheck(this.object, this.id, this.domainId, this.lastRunAt, this.proxyUrl, this.successful, this.createdAt, this.updatedAt);
        }
    }
}

