/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class PublicOrganizationData {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="slug")
    private String slug;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="image_url")
    private Optional<String> imageUrl;
    @JsonProperty(value="has_image")
    private boolean hasImage;

    @JsonCreator
    public PublicOrganizationData(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="slug") String slug, @JsonProperty(value="image_url") Optional<String> imageUrl, @JsonProperty(value="has_image") boolean hasImage) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(hasImage, "hasImage");
        this.id = id;
        this.name = name;
        this.slug = slug;
        this.imageUrl = imageUrl;
        this.hasImage = hasImage;
    }

    public PublicOrganizationData(String id, String name, String slug, boolean hasImage) {
        this(id, name, slug, Optional.empty(), hasImage);
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<String> imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public boolean hasImage() {
        return this.hasImage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PublicOrganizationData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public PublicOrganizationData withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public PublicOrganizationData withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public PublicOrganizationData withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = Optional.ofNullable(imageUrl);
        return this;
    }

    public PublicOrganizationData withImageUrl(Optional<String> imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public PublicOrganizationData withHasImage(boolean hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = hasImage;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicOrganizationData other = (PublicOrganizationData)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.imageUrl, other.imageUrl) && Utils.enhancedDeepEquals(this.hasImage, other.hasImage);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.name, this.slug, this.imageUrl, this.hasImage);
    }

    public String toString() {
        return Utils.toString(PublicOrganizationData.class, "id", this.id, "name", this.name, "slug", this.slug, "imageUrl", this.imageUrl, "hasImage", this.hasImage);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String slug;
        private Optional<String> imageUrl = Optional.empty();
        private Boolean hasImage;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        public Builder imageUrl(Optional<String> imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder hasImage(boolean hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = hasImage;
            return this;
        }

        public PublicOrganizationData build() {
            return new PublicOrganizationData(this.id, this.name, this.slug, this.imageUrl, this.hasImage);
        }
    }
}

