/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SAMLAccountObject;
import com.clerk.backend_api.models.components.SAMLAccountVerification;
import com.clerk.backend_api.models.components.SamlConnection;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class SAMLAccount {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private SAMLAccountObject object;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="active")
    private boolean active;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="first_name")
    private JsonNullable<String> firstName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_name")
    private JsonNullable<String> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="provider_user_id")
    private JsonNullable<String> providerUserId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_metadata")
    private Optional<? extends Map<String, Object>> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends SAMLAccountVerification> verification;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="saml_connection")
    private JsonNullable<? extends SamlConnection> samlConnection;

    @JsonCreator
    public SAMLAccount(@JsonProperty(value="id") String id, @JsonProperty(value="object") SAMLAccountObject object, @JsonProperty(value="provider") String provider, @JsonProperty(value="active") boolean active, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="first_name") JsonNullable<String> firstName, @JsonProperty(value="last_name") JsonNullable<String> lastName, @JsonProperty(value="provider_user_id") JsonNullable<String> providerUserId, @JsonProperty(value="public_metadata") Optional<? extends Map<String, Object>> publicMetadata, @JsonProperty(value="verification") Optional<? extends SAMLAccountVerification> verification, @JsonProperty(value="saml_connection") JsonNullable<? extends SamlConnection> samlConnection) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(providerUserId, "providerUserId");
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(samlConnection, "samlConnection");
        this.id = id;
        this.object = object;
        this.provider = provider;
        this.active = active;
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.providerUserId = providerUserId;
        this.publicMetadata = publicMetadata;
        this.verification = verification;
        this.samlConnection = samlConnection;
    }

    public SAMLAccount(String id, SAMLAccountObject object, String provider, boolean active, String emailAddress) {
        this(id, object, provider, active, emailAddress, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<? extends SamlConnection>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public SAMLAccountObject object() {
        return this.object;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public boolean active() {
        return this.active;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public JsonNullable<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public JsonNullable<String> lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public JsonNullable<String> providerUserId() {
        return this.providerUserId;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<SAMLAccountVerification> verification() {
        return this.verification;
    }

    @JsonIgnore
    public JsonNullable<SamlConnection> samlConnection() {
        return this.samlConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SAMLAccount withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SAMLAccount withObject(SAMLAccountObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public SAMLAccount withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public SAMLAccount withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public SAMLAccount withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public SAMLAccount withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of((Object)firstName);
        return this;
    }

    public SAMLAccount withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public SAMLAccount withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of((Object)lastName);
        return this;
    }

    public SAMLAccount withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public SAMLAccount withProviderUserId(String providerUserId) {
        Utils.checkNotNull(providerUserId, "providerUserId");
        this.providerUserId = JsonNullable.of((Object)providerUserId);
        return this;
    }

    public SAMLAccount withProviderUserId(JsonNullable<String> providerUserId) {
        Utils.checkNotNull(providerUserId, "providerUserId");
        this.providerUserId = providerUserId;
        return this;
    }

    public SAMLAccount withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = Optional.ofNullable(publicMetadata);
        return this;
    }

    public SAMLAccount withPublicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public SAMLAccount withVerification(SAMLAccountVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public SAMLAccount withVerification(Optional<? extends SAMLAccountVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public SAMLAccount withSamlConnection(SamlConnection samlConnection) {
        Utils.checkNotNull(samlConnection, "samlConnection");
        this.samlConnection = JsonNullable.of((Object)samlConnection);
        return this;
    }

    public SAMLAccount withSamlConnection(JsonNullable<? extends SamlConnection> samlConnection) {
        Utils.checkNotNull(samlConnection, "samlConnection");
        this.samlConnection = samlConnection;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLAccount other = (SAMLAccount)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.provider, other.provider) && Utils.enhancedDeepEquals(this.active, other.active) && Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals(this.firstName, other.firstName) && Utils.enhancedDeepEquals(this.lastName, other.lastName) && Utils.enhancedDeepEquals(this.providerUserId, other.providerUserId) && Utils.enhancedDeepEquals(this.publicMetadata, other.publicMetadata) && Utils.enhancedDeepEquals(this.verification, other.verification) && Utils.enhancedDeepEquals(this.samlConnection, other.samlConnection);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.id, this.object, this.provider, this.active, this.emailAddress, this.firstName, this.lastName, this.providerUserId, this.publicMetadata, this.verification, this.samlConnection});
    }

    public String toString() {
        return Utils.toString(SAMLAccount.class, new Object[]{"id", this.id, "object", this.object, "provider", this.provider, "active", this.active, "emailAddress", this.emailAddress, "firstName", this.firstName, "lastName", this.lastName, "providerUserId", this.providerUserId, "publicMetadata", this.publicMetadata, "verification", this.verification, "samlConnection", this.samlConnection});
    }

    public static final class Builder {
        private String id;
        private SAMLAccountObject object;
        private String provider;
        private Boolean active;
        private String emailAddress;
        private JsonNullable<String> firstName = JsonNullable.undefined();
        private JsonNullable<String> lastName = JsonNullable.undefined();
        private JsonNullable<String> providerUserId = JsonNullable.undefined();
        private Optional<? extends Map<String, Object>> publicMetadata = Optional.empty();
        private Optional<? extends SAMLAccountVerification> verification = Optional.empty();
        private JsonNullable<? extends SamlConnection> samlConnection = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(SAMLAccountObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of((Object)firstName);
            return this;
        }

        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of((Object)lastName);
            return this;
        }

        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder providerUserId(String providerUserId) {
            Utils.checkNotNull(providerUserId, "providerUserId");
            this.providerUserId = JsonNullable.of((Object)providerUserId);
            return this;
        }

        public Builder providerUserId(JsonNullable<String> providerUserId) {
            Utils.checkNotNull(providerUserId, "providerUserId");
            this.providerUserId = providerUserId;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = Optional.ofNullable(publicMetadata);
            return this;
        }

        public Builder publicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder verification(SAMLAccountVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends SAMLAccountVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Builder samlConnection(SamlConnection samlConnection) {
            Utils.checkNotNull(samlConnection, "samlConnection");
            this.samlConnection = JsonNullable.of((Object)samlConnection);
            return this;
        }

        public Builder samlConnection(JsonNullable<? extends SamlConnection> samlConnection) {
            Utils.checkNotNull(samlConnection, "samlConnection");
            this.samlConnection = samlConnection;
            return this;
        }

        public SAMLAccount build() {
            return new SAMLAccount(this.id, this.object, this.provider, this.active, this.emailAddress, this.firstName, this.lastName, this.providerUserId, this.publicMetadata, this.verification, this.samlConnection);
        }
    }
}

