/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SAMLConnectionAttributeMapping {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;

    @JsonCreator
    public SAMLConnectionAttributeMapping(@JsonProperty(value="user_id") String userId, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        this.userId = userId;
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public String lastName() {
        return this.lastName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SAMLConnectionAttributeMapping withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public SAMLConnectionAttributeMapping withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public SAMLConnectionAttributeMapping withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public SAMLConnectionAttributeMapping withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLConnectionAttributeMapping other = (SAMLConnectionAttributeMapping)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals(this.firstName, other.firstName) && Utils.enhancedDeepEquals(this.lastName, other.lastName);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.emailAddress, this.firstName, this.lastName);
    }

    public String toString() {
        return Utils.toString(SAMLConnectionAttributeMapping.class, "userId", this.userId, "emailAddress", this.emailAddress, "firstName", this.firstName, "lastName", this.lastName);
    }

    public static final class Builder {
        private String userId;
        private String emailAddress;
        private String firstName;
        private String lastName;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public SAMLConnectionAttributeMapping build() {
            return new SAMLConnectionAttributeMapping(this.userId, this.emailAddress, this.firstName, this.lastName);
        }
    }
}

