/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Verification;
import com.clerk.backend_api.models.components.VerificationError;
import com.clerk.backend_api.models.components.VerificationSamlVerificationObject;
import com.clerk.backend_api.models.components.VerificationSamlVerificationStatus;
import com.clerk.backend_api.models.components.VerificationSamlVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Saml
implements Verification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationSamlVerificationObject> object;
    @JsonProperty(value="status")
    private VerificationSamlVerificationStatus status;
    @JsonProperty(value="strategy")
    private VerificationSamlVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_verification_redirect_url")
    private JsonNullable<String> externalVerificationRedirectUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends VerificationError> error;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expire_at")
    private JsonNullable<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Saml(@JsonProperty(value="object") Optional<? extends VerificationSamlVerificationObject> object, @JsonProperty(value="status") VerificationSamlVerificationStatus status, @JsonProperty(value="strategy") VerificationSamlVerificationStrategy strategy, @JsonProperty(value="external_verification_redirect_url") JsonNullable<String> externalVerificationRedirectUrl, @JsonProperty(value="error") JsonNullable<? extends VerificationError> error, @JsonProperty(value="expire_at") JsonNullable<Long> expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        this.error = error;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Saml(VerificationSamlVerificationStatus status, VerificationSamlVerificationStrategy strategy) {
        this(Optional.empty(), status, strategy, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends VerificationError>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationSamlVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public VerificationSamlVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public JsonNullable<String> externalVerificationRedirectUrl() {
        return this.externalVerificationRedirectUrl;
    }

    @JsonIgnore
    public JsonNullable<VerificationError> error() {
        return this.error;
    }

    @JsonIgnore
    public JsonNullable<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Saml withObject(VerificationSamlVerificationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public Saml withObject(Optional<? extends VerificationSamlVerificationObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Saml withStatus(VerificationSamlVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Saml withStrategy(VerificationSamlVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Saml withExternalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = JsonNullable.of((Object)externalVerificationRedirectUrl);
        return this;
    }

    public Saml withExternalVerificationRedirectUrl(JsonNullable<String> externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        return this;
    }

    public Saml withError(VerificationError error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public Saml withError(JsonNullable<? extends VerificationError> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public Saml withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = JsonNullable.of((Object)expireAt);
        return this;
    }

    public Saml withExpireAt(JsonNullable<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Saml withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Saml withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Saml withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Saml withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml other = (Saml)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals((Object)this.strategy, (Object)other.strategy) && Utils.enhancedDeepEquals(this.externalVerificationRedirectUrl, other.externalVerificationRedirectUrl) && Utils.enhancedDeepEquals(this.error, other.error) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(Saml.class, new Object[]{"object", this.object, "status", this.status, "strategy", this.strategy, "externalVerificationRedirectUrl", this.externalVerificationRedirectUrl, "error", this.error, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Optional<? extends VerificationSamlVerificationObject> object = Optional.empty();
        private VerificationSamlVerificationStatus status;
        private VerificationSamlVerificationStrategy strategy;
        private JsonNullable<String> externalVerificationRedirectUrl = JsonNullable.undefined();
        private JsonNullable<? extends VerificationError> error = JsonNullable.undefined();
        private JsonNullable<Long> expireAt = JsonNullable.undefined();
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationSamlVerificationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationSamlVerificationObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationSamlVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(VerificationSamlVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder externalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = JsonNullable.of((Object)externalVerificationRedirectUrl);
            return this;
        }

        public Builder externalVerificationRedirectUrl(JsonNullable<String> externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
            return this;
        }

        public Builder error(VerificationError error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends VerificationError> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = JsonNullable.of((Object)expireAt);
            return this;
        }

        public Builder expireAt(JsonNullable<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Saml build() {
            return new Saml(this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
        }
    }
}

