/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.HasSecurity;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class Security
implements HasSecurity {
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=bearer,name=Authorization")
    private Optional<String> bearerAuth;

    @JsonCreator
    public Security(Optional<String> bearerAuth) {
        Utils.checkNotNull(bearerAuth, "bearerAuth");
        this.bearerAuth = bearerAuth;
    }

    public Security() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> bearerAuth() {
        return this.bearerAuth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Security withBearerAuth(String bearerAuth) {
        Utils.checkNotNull(bearerAuth, "bearerAuth");
        this.bearerAuth = Optional.ofNullable(bearerAuth);
        return this;
    }

    public Security withBearerAuth(Optional<String> bearerAuth) {
        Utils.checkNotNull(bearerAuth, "bearerAuth");
        this.bearerAuth = bearerAuth;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security)o;
        return Utils.enhancedDeepEquals(this.bearerAuth, other.bearerAuth);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.bearerAuth);
    }

    public String toString() {
        return Utils.toString(Security.class, "bearerAuth", this.bearerAuth);
    }

    public static final class Builder {
        private Optional<String> bearerAuth = Optional.empty();

        private Builder() {
        }

        public Builder bearerAuth(String bearerAuth) {
            Utils.checkNotNull(bearerAuth, "bearerAuth");
            this.bearerAuth = Optional.ofNullable(bearerAuth);
            return this;
        }

        public Builder bearerAuth(Optional<String> bearerAuth) {
            Utils.checkNotNull(bearerAuth, "bearerAuth");
            this.bearerAuth = bearerAuth;
            return this;
        }

        public Security build() {
            return new Security(this.bearerAuth);
        }
    }
}

