/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SessionTask {
    @JsonProperty(value="key")
    private String key;

    @JsonCreator
    public SessionTask(@JsonProperty(value="key") String key) {
        Utils.checkNotNull(key, "key");
        this.key = key;
    }

    @JsonIgnore
    public String key() {
        return this.key;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SessionTask withKey(String key) {
        Utils.checkNotNull(key, "key");
        this.key = key;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTask other = (SessionTask)o;
        return Utils.enhancedDeepEquals(this.key, other.key);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.key);
    }

    public String toString() {
        return Utils.toString(SessionTask.class, "key", this.key);
    }

    public static final class Builder {
        private String key;

        private Builder() {
        }

        public Builder key(String key) {
            Utils.checkNotNull(key, "key");
            this.key = key;
            return this;
        }

        public SessionTask build() {
            return new SessionTask(this.key);
        }
    }
}

