/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.NextAction;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SignUpVerification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="next_action")
    private Optional<? extends NextAction> nextAction;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="supported_strategies")
    private Optional<? extends List<String>> supportedStrategies;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    @JsonCreator
    public SignUpVerification(@JsonProperty(value="next_action") Optional<? extends NextAction> nextAction, @JsonProperty(value="supported_strategies") Optional<? extends List<String>> supportedStrategies) {
        Utils.checkNotNull(nextAction, "nextAction");
        Utils.checkNotNull(supportedStrategies, "supportedStrategies");
        this.nextAction = nextAction;
        this.supportedStrategies = supportedStrategies;
        this.additionalProperties = new HashMap<String, Object>();
    }

    public SignUpVerification() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<NextAction> nextAction() {
        return this.nextAction;
    }

    @JsonIgnore
    public Optional<List<String>> supportedStrategies() {
        return this.supportedStrategies;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SignUpVerification withNextAction(NextAction nextAction) {
        Utils.checkNotNull(nextAction, "nextAction");
        this.nextAction = Optional.ofNullable(nextAction);
        return this;
    }

    public SignUpVerification withNextAction(Optional<? extends NextAction> nextAction) {
        Utils.checkNotNull(nextAction, "nextAction");
        this.nextAction = nextAction;
        return this;
    }

    public SignUpVerification withSupportedStrategies(List<String> supportedStrategies) {
        Utils.checkNotNull(supportedStrategies, "supportedStrategies");
        this.supportedStrategies = Optional.ofNullable(supportedStrategies);
        return this;
    }

    public SignUpVerification withSupportedStrategies(Optional<? extends List<String>> supportedStrategies) {
        Utils.checkNotNull(supportedStrategies, "supportedStrategies");
        this.supportedStrategies = supportedStrategies;
        return this;
    }

    @JsonAnySetter
    public SignUpVerification withAdditionalProperty(String key, Object value) {
        Utils.checkNotNull(key, "key");
        this.additionalProperties.put(key, value);
        return this;
    }

    public SignUpVerification withAdditionalProperties(Map<String, Object> additionalProperties) {
        Utils.checkNotNull(additionalProperties, "additionalProperties");
        this.additionalProperties = additionalProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignUpVerification other = (SignUpVerification)o;
        return Utils.enhancedDeepEquals(this.nextAction, other.nextAction) && Utils.enhancedDeepEquals(this.supportedStrategies, other.supportedStrategies) && Utils.enhancedDeepEquals(this.additionalProperties, other.additionalProperties);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.nextAction, this.supportedStrategies, this.additionalProperties);
    }

    public String toString() {
        return Utils.toString(SignUpVerification.class, "nextAction", this.nextAction, "supportedStrategies", this.supportedStrategies, "additionalProperties", this.additionalProperties);
    }

    public static final class Builder {
        private Optional<? extends NextAction> nextAction = Optional.empty();
        private Optional<? extends List<String>> supportedStrategies = Optional.empty();
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder nextAction(NextAction nextAction) {
            Utils.checkNotNull(nextAction, "nextAction");
            this.nextAction = Optional.ofNullable(nextAction);
            return this;
        }

        public Builder nextAction(Optional<? extends NextAction> nextAction) {
            Utils.checkNotNull(nextAction, "nextAction");
            this.nextAction = nextAction;
            return this;
        }

        public Builder supportedStrategies(List<String> supportedStrategies) {
            Utils.checkNotNull(supportedStrategies, "supportedStrategies");
            this.supportedStrategies = Optional.ofNullable(supportedStrategies);
            return this;
        }

        public Builder supportedStrategies(Optional<? extends List<String>> supportedStrategies) {
            Utils.checkNotNull(supportedStrategies, "supportedStrategies");
            this.supportedStrategies = supportedStrategies;
            return this;
        }

        public Builder additionalProperty(String key, Object value) {
            Utils.checkNotNull(key, "key");
            this.additionalProperties.put(key, value);
            return this;
        }

        public Builder additionalProperties(Map<String, Object> additionalProperties) {
            Utils.checkNotNull(additionalProperties, "additionalProperties");
            this.additionalProperties = additionalProperties;
            return this;
        }

        public SignUpVerification build() {
            return new SignUpVerification(this.nextAction, this.supportedStrategies).withAdditionalProperties(this.additionalProperties);
        }
    }
}

