/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ExternalAccount;
import com.clerk.backend_api.models.components.SignUpVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class SignUpVerifications {
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="email_address")
    private Optional<? extends SignUpVerification> emailAddress;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="phone_number")
    private Optional<? extends SignUpVerification> phoneNumber;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="web3_wallet")
    private Optional<? extends SignUpVerification> web3Wallet;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="external_account")
    private Optional<? extends ExternalAccount> externalAccount;

    @JsonCreator
    public SignUpVerifications(@JsonProperty(value="email_address") Optional<? extends SignUpVerification> emailAddress, @JsonProperty(value="phone_number") Optional<? extends SignUpVerification> phoneNumber, @JsonProperty(value="web3_wallet") Optional<? extends SignUpVerification> web3Wallet, @JsonProperty(value="external_account") Optional<? extends ExternalAccount> externalAccount) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.web3Wallet = web3Wallet;
        this.externalAccount = externalAccount;
    }

    public SignUpVerifications() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<SignUpVerification> emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<SignUpVerification> phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<SignUpVerification> web3Wallet() {
        return this.web3Wallet;
    }

    @JsonIgnore
    public Optional<ExternalAccount> externalAccount() {
        return this.externalAccount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SignUpVerifications withEmailAddress(SignUpVerification emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = Optional.ofNullable(emailAddress);
        return this;
    }

    public SignUpVerifications withEmailAddress(Optional<? extends SignUpVerification> emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public SignUpVerifications withPhoneNumber(SignUpVerification phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = Optional.ofNullable(phoneNumber);
        return this;
    }

    public SignUpVerifications withPhoneNumber(Optional<? extends SignUpVerification> phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public SignUpVerifications withWeb3Wallet(SignUpVerification web3Wallet) {
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        this.web3Wallet = Optional.ofNullable(web3Wallet);
        return this;
    }

    public SignUpVerifications withWeb3Wallet(Optional<? extends SignUpVerification> web3Wallet) {
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        this.web3Wallet = web3Wallet;
        return this;
    }

    public SignUpVerifications withExternalAccount(ExternalAccount externalAccount) {
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.externalAccount = Optional.ofNullable(externalAccount);
        return this;
    }

    public SignUpVerifications withExternalAccount(Optional<? extends ExternalAccount> externalAccount) {
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.externalAccount = externalAccount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignUpVerifications other = (SignUpVerifications)o;
        return Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals(this.phoneNumber, other.phoneNumber) && Utils.enhancedDeepEquals(this.web3Wallet, other.web3Wallet) && Utils.enhancedDeepEquals(this.externalAccount, other.externalAccount);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.emailAddress, this.phoneNumber, this.web3Wallet, this.externalAccount);
    }

    public String toString() {
        return Utils.toString(SignUpVerifications.class, "emailAddress", this.emailAddress, "phoneNumber", this.phoneNumber, "web3Wallet", this.web3Wallet, "externalAccount", this.externalAccount);
    }

    public static final class Builder {
        private Optional<? extends SignUpVerification> emailAddress = Optional.empty();
        private Optional<? extends SignUpVerification> phoneNumber = Optional.empty();
        private Optional<? extends SignUpVerification> web3Wallet = Optional.empty();
        private Optional<? extends ExternalAccount> externalAccount = Optional.empty();

        private Builder() {
        }

        public Builder emailAddress(SignUpVerification emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Optional<? extends SignUpVerification> emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(SignUpVerification phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Optional<? extends SignUpVerification> phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder web3Wallet(SignUpVerification web3Wallet) {
            Utils.checkNotNull(web3Wallet, "web3Wallet");
            this.web3Wallet = Optional.ofNullable(web3Wallet);
            return this;
        }

        public Builder web3Wallet(Optional<? extends SignUpVerification> web3Wallet) {
            Utils.checkNotNull(web3Wallet, "web3Wallet");
            this.web3Wallet = web3Wallet;
            return this;
        }

        public Builder externalAccount(ExternalAccount externalAccount) {
            Utils.checkNotNull(externalAccount, "externalAccount");
            this.externalAccount = Optional.ofNullable(externalAccount);
            return this;
        }

        public Builder externalAccount(Optional<? extends ExternalAccount> externalAccount) {
            Utils.checkNotNull(externalAccount, "externalAccount");
            this.externalAccount = externalAccount;
            return this;
        }

        public SignUpVerifications build() {
            return new SignUpVerifications(this.emailAddress, this.phoneNumber, this.web3Wallet, this.externalAccount);
        }
    }
}

