/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.TestingTokenObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TestingToken {
    @JsonProperty(value="object")
    private TestingTokenObject object;
    @JsonProperty(value="token")
    private String token;
    @JsonProperty(value="expires_at")
    private long expiresAt;

    @JsonCreator
    public TestingToken(@JsonProperty(value="object") TestingTokenObject object, @JsonProperty(value="token") String token, @JsonProperty(value="expires_at") long expiresAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.object = object;
        this.token = token;
        this.expiresAt = expiresAt;
    }

    @JsonIgnore
    public TestingTokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String token() {
        return this.token;
    }

    @JsonIgnore
    public long expiresAt() {
        return this.expiresAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TestingToken withObject(TestingTokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public TestingToken withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public TestingToken withExpiresAt(long expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestingToken other = (TestingToken)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.token, other.token) && Utils.enhancedDeepEquals(this.expiresAt, other.expiresAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.token, this.expiresAt});
    }

    public String toString() {
        return Utils.toString(TestingToken.class, new Object[]{"object", this.object, "token", this.token, "expiresAt", this.expiresAt});
    }

    public static final class Builder {
        private TestingTokenObject object;
        private String token;
        private Long expiresAt;

        private Builder() {
        }

        public Builder object(TestingTokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public TestingToken build() {
            return new TestingToken(this.object, this.token, this.expiresAt);
        }
    }
}

