/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.TokenObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Token {
    @JsonProperty(value="object")
    private TokenObject object;
    @JsonProperty(value="jwt")
    private String jwt;

    @JsonCreator
    public Token(@JsonProperty(value="object") TokenObject object, @JsonProperty(value="jwt") String jwt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(jwt, "jwt");
        this.object = object;
        this.jwt = jwt;
    }

    @JsonIgnore
    public TokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String jwt() {
        return this.jwt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Token withObject(TokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Token withJwt(String jwt) {
        Utils.checkNotNull(jwt, "jwt");
        this.jwt = jwt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token other = (Token)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.jwt, other.jwt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.jwt});
    }

    public String toString() {
        return Utils.toString(Token.class, new Object[]{"object", this.object, "jwt", this.jwt});
    }

    public static final class Builder {
        private TokenObject object;
        private String jwt;

        private Builder() {
        }

        public Builder object(TokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder jwt(String jwt) {
            Utils.checkNotNull(jwt, "jwt");
            this.jwt = jwt;
            return this;
        }

        public Token build() {
            return new Token(this.object, this.jwt);
        }
    }
}

