/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.EmailAddress;
import com.clerk.backend_api.models.components.ExternalAccountWithVerification;
import com.clerk.backend_api.models.components.Passkey;
import com.clerk.backend_api.models.components.PhoneNumber;
import com.clerk.backend_api.models.components.SAMLAccount;
import com.clerk.backend_api.models.components.UserObject;
import com.clerk.backend_api.models.components.Web3Wallet;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class User {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private UserObject object;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="external_id")
    private Optional<String> externalId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="primary_email_address_id")
    private Optional<String> primaryEmailAddressId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="primary_phone_number_id")
    private Optional<String> primaryPhoneNumberId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="primary_web3_wallet_id")
    private Optional<String> primaryWeb3WalletId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="username")
    private Optional<String> username;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="first_name")
    private Optional<String> firstName;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_name")
    private Optional<String> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="profile_image_url")
    @Deprecated
    private Optional<String> profileImageUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="image_url")
    private Optional<String> imageUrl;
    @JsonProperty(value="has_image")
    private boolean hasImage;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="private_metadata")
    private JsonNullable<? extends Map<String, Object>> privateMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unsafe_metadata")
    private Optional<? extends Map<String, Object>> unsafeMetadata;
    @JsonProperty(value="email_addresses")
    private List<EmailAddress> emailAddresses;
    @JsonProperty(value="phone_numbers")
    private List<PhoneNumber> phoneNumbers;
    @JsonProperty(value="web3_wallets")
    private List<Web3Wallet> web3Wallets;
    @JsonProperty(value="passkeys")
    private List<Passkey> passkeys;
    @JsonProperty(value="password_enabled")
    private boolean passwordEnabled;
    @JsonProperty(value="two_factor_enabled")
    private boolean twoFactorEnabled;
    @JsonProperty(value="totp_enabled")
    private boolean totpEnabled;
    @JsonProperty(value="backup_code_enabled")
    private boolean backupCodeEnabled;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="mfa_enabled_at")
    private Optional<Long> mfaEnabledAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="mfa_disabled_at")
    private Optional<Long> mfaDisabledAt;
    @JsonProperty(value="external_accounts")
    private List<ExternalAccountWithVerification> externalAccounts;
    @JsonProperty(value="saml_accounts")
    private List<SAMLAccount> samlAccounts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_sign_in_at")
    private Optional<Long> lastSignInAt;
    @JsonProperty(value="banned")
    private boolean banned;
    @JsonProperty(value="locked")
    private boolean locked;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="lockout_expires_in_seconds")
    private Optional<Long> lockoutExpiresInSeconds;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification_attempts_remaining")
    private Optional<Long> verificationAttemptsRemaining;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="delete_self_enabled")
    private boolean deleteSelfEnabled;
    @JsonProperty(value="create_organization_enabled")
    private boolean createOrganizationEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="create_organizations_limit")
    private JsonNullable<Long> createOrganizationsLimit;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_active_at")
    private Optional<Long> lastActiveAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="legal_accepted_at")
    private Optional<Long> legalAcceptedAt;

    @JsonCreator
    public User(@JsonProperty(value="id") String id, @JsonProperty(value="object") UserObject object, @JsonProperty(value="external_id") Optional<String> externalId, @JsonProperty(value="primary_email_address_id") Optional<String> primaryEmailAddressId, @JsonProperty(value="primary_phone_number_id") Optional<String> primaryPhoneNumberId, @JsonProperty(value="primary_web3_wallet_id") Optional<String> primaryWeb3WalletId, @JsonProperty(value="username") Optional<String> username, @JsonProperty(value="first_name") Optional<String> firstName, @JsonProperty(value="last_name") Optional<String> lastName, @JsonProperty(value="profile_image_url") Optional<String> profileImageUrl, @JsonProperty(value="image_url") Optional<String> imageUrl, @JsonProperty(value="has_image") boolean hasImage, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="private_metadata") JsonNullable<? extends Map<String, Object>> privateMetadata, @JsonProperty(value="unsafe_metadata") Optional<? extends Map<String, Object>> unsafeMetadata, @JsonProperty(value="email_addresses") List<EmailAddress> emailAddresses, @JsonProperty(value="phone_numbers") List<PhoneNumber> phoneNumbers, @JsonProperty(value="web3_wallets") List<Web3Wallet> web3Wallets, @JsonProperty(value="passkeys") List<Passkey> passkeys, @JsonProperty(value="password_enabled") boolean passwordEnabled, @JsonProperty(value="two_factor_enabled") boolean twoFactorEnabled, @JsonProperty(value="totp_enabled") boolean totpEnabled, @JsonProperty(value="backup_code_enabled") boolean backupCodeEnabled, @JsonProperty(value="mfa_enabled_at") Optional<Long> mfaEnabledAt, @JsonProperty(value="mfa_disabled_at") Optional<Long> mfaDisabledAt, @JsonProperty(value="external_accounts") List<ExternalAccountWithVerification> externalAccounts, @JsonProperty(value="saml_accounts") List<SAMLAccount> samlAccounts, @JsonProperty(value="last_sign_in_at") Optional<Long> lastSignInAt, @JsonProperty(value="banned") boolean banned, @JsonProperty(value="locked") boolean locked, @JsonProperty(value="lockout_expires_in_seconds") Optional<Long> lockoutExpiresInSeconds, @JsonProperty(value="verification_attempts_remaining") Optional<Long> verificationAttemptsRemaining, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="delete_self_enabled") boolean deleteSelfEnabled, @JsonProperty(value="create_organization_enabled") boolean createOrganizationEnabled, @JsonProperty(value="create_organizations_limit") JsonNullable<Long> createOrganizationsLimit, @JsonProperty(value="last_active_at") Optional<Long> lastActiveAt, @JsonProperty(value="legal_accepted_at") Optional<Long> legalAcceptedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(externalId, "externalId");
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(hasImage, "hasImage");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        Utils.checkNotNull(web3Wallets, "web3Wallets");
        Utils.checkNotNull(passkeys, "passkeys");
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
        Utils.checkNotNull(totpEnabled, "totpEnabled");
        Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        Utils.checkNotNull(externalAccounts, "externalAccounts");
        Utils.checkNotNull(samlAccounts, "samlAccounts");
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        Utils.checkNotNull(banned, "banned");
        Utils.checkNotNull(locked, "locked");
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
        Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.id = id;
        this.object = object;
        this.externalId = externalId;
        this.primaryEmailAddressId = primaryEmailAddressId;
        this.primaryPhoneNumberId = primaryPhoneNumberId;
        this.primaryWeb3WalletId = primaryWeb3WalletId;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.profileImageUrl = profileImageUrl;
        this.imageUrl = imageUrl;
        this.hasImage = hasImage;
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.unsafeMetadata = unsafeMetadata;
        this.emailAddresses = emailAddresses;
        this.phoneNumbers = phoneNumbers;
        this.web3Wallets = web3Wallets;
        this.passkeys = passkeys;
        this.passwordEnabled = passwordEnabled;
        this.twoFactorEnabled = twoFactorEnabled;
        this.totpEnabled = totpEnabled;
        this.backupCodeEnabled = backupCodeEnabled;
        this.mfaEnabledAt = mfaEnabledAt;
        this.mfaDisabledAt = mfaDisabledAt;
        this.externalAccounts = externalAccounts;
        this.samlAccounts = samlAccounts;
        this.lastSignInAt = lastSignInAt;
        this.banned = banned;
        this.locked = locked;
        this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
        this.verificationAttemptsRemaining = verificationAttemptsRemaining;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
        this.deleteSelfEnabled = deleteSelfEnabled;
        this.createOrganizationEnabled = createOrganizationEnabled;
        this.createOrganizationsLimit = createOrganizationsLimit;
        this.lastActiveAt = lastActiveAt;
        this.legalAcceptedAt = legalAcceptedAt;
    }

    public User(String id, UserObject object, boolean hasImage, Map<String, Object> publicMetadata, List<EmailAddress> emailAddresses, List<PhoneNumber> phoneNumbers, List<Web3Wallet> web3Wallets, List<Passkey> passkeys, boolean passwordEnabled, boolean twoFactorEnabled, boolean totpEnabled, boolean backupCodeEnabled, List<ExternalAccountWithVerification> externalAccounts, List<SAMLAccount> samlAccounts, boolean banned, boolean locked, long updatedAt, long createdAt, boolean deleteSelfEnabled, boolean createOrganizationEnabled) {
        this(id, object, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), hasImage, publicMetadata, (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), Optional.empty(), emailAddresses, phoneNumbers, web3Wallets, passkeys, passwordEnabled, twoFactorEnabled, totpEnabled, backupCodeEnabled, Optional.empty(), Optional.empty(), externalAccounts, samlAccounts, Optional.empty(), banned, locked, Optional.empty(), Optional.empty(), updatedAt, createdAt, deleteSelfEnabled, createOrganizationEnabled, (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public UserObject object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> externalId() {
        return this.externalId;
    }

    @JsonIgnore
    public Optional<String> primaryEmailAddressId() {
        return this.primaryEmailAddressId;
    }

    @JsonIgnore
    public Optional<String> primaryPhoneNumberId() {
        return this.primaryPhoneNumberId;
    }

    @JsonIgnore
    public Optional<String> primaryWeb3WalletId() {
        return this.primaryWeb3WalletId;
    }

    @JsonIgnore
    public Optional<String> username() {
        return this.username;
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return this.lastName;
    }

    @Deprecated
    @JsonIgnore
    public Optional<String> profileImageUrl() {
        return this.profileImageUrl;
    }

    @JsonIgnore
    public Optional<String> imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public boolean hasImage() {
        return this.hasImage;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> unsafeMetadata() {
        return this.unsafeMetadata;
    }

    @JsonIgnore
    public List<EmailAddress> emailAddresses() {
        return this.emailAddresses;
    }

    @JsonIgnore
    public List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonIgnore
    public List<Web3Wallet> web3Wallets() {
        return this.web3Wallets;
    }

    @JsonIgnore
    public List<Passkey> passkeys() {
        return this.passkeys;
    }

    @JsonIgnore
    public boolean passwordEnabled() {
        return this.passwordEnabled;
    }

    @JsonIgnore
    public boolean twoFactorEnabled() {
        return this.twoFactorEnabled;
    }

    @JsonIgnore
    public boolean totpEnabled() {
        return this.totpEnabled;
    }

    @JsonIgnore
    public boolean backupCodeEnabled() {
        return this.backupCodeEnabled;
    }

    @JsonIgnore
    public Optional<Long> mfaEnabledAt() {
        return this.mfaEnabledAt;
    }

    @JsonIgnore
    public Optional<Long> mfaDisabledAt() {
        return this.mfaDisabledAt;
    }

    @JsonIgnore
    public List<ExternalAccountWithVerification> externalAccounts() {
        return this.externalAccounts;
    }

    @JsonIgnore
    public List<SAMLAccount> samlAccounts() {
        return this.samlAccounts;
    }

    @JsonIgnore
    public Optional<Long> lastSignInAt() {
        return this.lastSignInAt;
    }

    @JsonIgnore
    public boolean banned() {
        return this.banned;
    }

    @JsonIgnore
    public boolean locked() {
        return this.locked;
    }

    @JsonIgnore
    public Optional<Long> lockoutExpiresInSeconds() {
        return this.lockoutExpiresInSeconds;
    }

    @JsonIgnore
    public Optional<Long> verificationAttemptsRemaining() {
        return this.verificationAttemptsRemaining;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public boolean deleteSelfEnabled() {
        return this.deleteSelfEnabled;
    }

    @JsonIgnore
    public boolean createOrganizationEnabled() {
        return this.createOrganizationEnabled;
    }

    @JsonIgnore
    public JsonNullable<Long> createOrganizationsLimit() {
        return this.createOrganizationsLimit;
    }

    @JsonIgnore
    public Optional<Long> lastActiveAt() {
        return this.lastActiveAt;
    }

    @JsonIgnore
    public Optional<Long> legalAcceptedAt() {
        return this.legalAcceptedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public User withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public User withObject(UserObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public User withExternalId(String externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = Optional.ofNullable(externalId);
        return this;
    }

    public User withExternalId(Optional<String> externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = externalId;
        return this;
    }

    public User withPrimaryEmailAddressId(String primaryEmailAddressId) {
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        this.primaryEmailAddressId = Optional.ofNullable(primaryEmailAddressId);
        return this;
    }

    public User withPrimaryEmailAddressId(Optional<String> primaryEmailAddressId) {
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        this.primaryEmailAddressId = primaryEmailAddressId;
        return this;
    }

    public User withPrimaryPhoneNumberId(String primaryPhoneNumberId) {
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        this.primaryPhoneNumberId = Optional.ofNullable(primaryPhoneNumberId);
        return this;
    }

    public User withPrimaryPhoneNumberId(Optional<String> primaryPhoneNumberId) {
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        this.primaryPhoneNumberId = primaryPhoneNumberId;
        return this;
    }

    public User withPrimaryWeb3WalletId(String primaryWeb3WalletId) {
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        this.primaryWeb3WalletId = Optional.ofNullable(primaryWeb3WalletId);
        return this;
    }

    public User withPrimaryWeb3WalletId(Optional<String> primaryWeb3WalletId) {
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        this.primaryWeb3WalletId = primaryWeb3WalletId;
        return this;
    }

    public User withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = Optional.ofNullable(username);
        return this;
    }

    public User withUsername(Optional<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public User withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public User withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public User withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public User withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    @Deprecated
    public User withProfileImageUrl(String profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = Optional.ofNullable(profileImageUrl);
        return this;
    }

    @Deprecated
    public User withProfileImageUrl(Optional<String> profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = profileImageUrl;
        return this;
    }

    public User withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = Optional.ofNullable(imageUrl);
        return this;
    }

    public User withImageUrl(Optional<String> imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public User withHasImage(boolean hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = hasImage;
        return this;
    }

    public User withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public User withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = JsonNullable.of(privateMetadata);
        return this;
    }

    public User withPrivateMetadata(JsonNullable<? extends Map<String, Object>> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public User withUnsafeMetadata(Map<String, Object> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
        return this;
    }

    public User withUnsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = unsafeMetadata;
        return this;
    }

    public User withEmailAddresses(List<EmailAddress> emailAddresses) {
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        this.emailAddresses = emailAddresses;
        return this;
    }

    public User withPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public User withWeb3Wallets(List<Web3Wallet> web3Wallets) {
        Utils.checkNotNull(web3Wallets, "web3Wallets");
        this.web3Wallets = web3Wallets;
        return this;
    }

    public User withPasskeys(List<Passkey> passkeys) {
        Utils.checkNotNull(passkeys, "passkeys");
        this.passkeys = passkeys;
        return this;
    }

    public User withPasswordEnabled(boolean passwordEnabled) {
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        this.passwordEnabled = passwordEnabled;
        return this;
    }

    public User withTwoFactorEnabled(boolean twoFactorEnabled) {
        Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
        this.twoFactorEnabled = twoFactorEnabled;
        return this;
    }

    public User withTotpEnabled(boolean totpEnabled) {
        Utils.checkNotNull(totpEnabled, "totpEnabled");
        this.totpEnabled = totpEnabled;
        return this;
    }

    public User withBackupCodeEnabled(boolean backupCodeEnabled) {
        Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
        this.backupCodeEnabled = backupCodeEnabled;
        return this;
    }

    public User withMfaEnabledAt(long mfaEnabledAt) {
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        this.mfaEnabledAt = Optional.ofNullable(mfaEnabledAt);
        return this;
    }

    public User withMfaEnabledAt(Optional<Long> mfaEnabledAt) {
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        this.mfaEnabledAt = mfaEnabledAt;
        return this;
    }

    public User withMfaDisabledAt(long mfaDisabledAt) {
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        this.mfaDisabledAt = Optional.ofNullable(mfaDisabledAt);
        return this;
    }

    public User withMfaDisabledAt(Optional<Long> mfaDisabledAt) {
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        this.mfaDisabledAt = mfaDisabledAt;
        return this;
    }

    public User withExternalAccounts(List<ExternalAccountWithVerification> externalAccounts) {
        Utils.checkNotNull(externalAccounts, "externalAccounts");
        this.externalAccounts = externalAccounts;
        return this;
    }

    public User withSamlAccounts(List<SAMLAccount> samlAccounts) {
        Utils.checkNotNull(samlAccounts, "samlAccounts");
        this.samlAccounts = samlAccounts;
        return this;
    }

    public User withLastSignInAt(long lastSignInAt) {
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        this.lastSignInAt = Optional.ofNullable(lastSignInAt);
        return this;
    }

    public User withLastSignInAt(Optional<Long> lastSignInAt) {
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        this.lastSignInAt = lastSignInAt;
        return this;
    }

    public User withBanned(boolean banned) {
        Utils.checkNotNull(banned, "banned");
        this.banned = banned;
        return this;
    }

    public User withLocked(boolean locked) {
        Utils.checkNotNull(locked, "locked");
        this.locked = locked;
        return this;
    }

    public User withLockoutExpiresInSeconds(long lockoutExpiresInSeconds) {
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        this.lockoutExpiresInSeconds = Optional.ofNullable(lockoutExpiresInSeconds);
        return this;
    }

    public User withLockoutExpiresInSeconds(Optional<Long> lockoutExpiresInSeconds) {
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
        return this;
    }

    public User withVerificationAttemptsRemaining(long verificationAttemptsRemaining) {
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        this.verificationAttemptsRemaining = Optional.ofNullable(verificationAttemptsRemaining);
        return this;
    }

    public User withVerificationAttemptsRemaining(Optional<Long> verificationAttemptsRemaining) {
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        this.verificationAttemptsRemaining = verificationAttemptsRemaining;
        return this;
    }

    public User withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public User withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public User withDeleteSelfEnabled(boolean deleteSelfEnabled) {
        Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
        this.deleteSelfEnabled = deleteSelfEnabled;
        return this;
    }

    public User withCreateOrganizationEnabled(boolean createOrganizationEnabled) {
        Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
        this.createOrganizationEnabled = createOrganizationEnabled;
        return this;
    }

    public User withCreateOrganizationsLimit(long createOrganizationsLimit) {
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        this.createOrganizationsLimit = JsonNullable.of((Object)createOrganizationsLimit);
        return this;
    }

    public User withCreateOrganizationsLimit(JsonNullable<Long> createOrganizationsLimit) {
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        this.createOrganizationsLimit = createOrganizationsLimit;
        return this;
    }

    public User withLastActiveAt(long lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = Optional.ofNullable(lastActiveAt);
        return this;
    }

    public User withLastActiveAt(Optional<Long> lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = lastActiveAt;
        return this;
    }

    public User withLegalAcceptedAt(long legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = Optional.ofNullable(legalAcceptedAt);
        return this;
    }

    public User withLegalAcceptedAt(Optional<Long> legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = legalAcceptedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.externalId, other.externalId) && Utils.enhancedDeepEquals(this.primaryEmailAddressId, other.primaryEmailAddressId) && Utils.enhancedDeepEquals(this.primaryPhoneNumberId, other.primaryPhoneNumberId) && Utils.enhancedDeepEquals(this.primaryWeb3WalletId, other.primaryWeb3WalletId) && Utils.enhancedDeepEquals(this.username, other.username) && Utils.enhancedDeepEquals(this.firstName, other.firstName) && Utils.enhancedDeepEquals(this.lastName, other.lastName) && Utils.enhancedDeepEquals(this.profileImageUrl, other.profileImageUrl) && Utils.enhancedDeepEquals(this.imageUrl, other.imageUrl) && Utils.enhancedDeepEquals(this.hasImage, other.hasImage) && Utils.enhancedDeepEquals(this.publicMetadata, other.publicMetadata) && Utils.enhancedDeepEquals(this.privateMetadata, other.privateMetadata) && Utils.enhancedDeepEquals(this.unsafeMetadata, other.unsafeMetadata) && Utils.enhancedDeepEquals(this.emailAddresses, other.emailAddresses) && Utils.enhancedDeepEquals(this.phoneNumbers, other.phoneNumbers) && Utils.enhancedDeepEquals(this.web3Wallets, other.web3Wallets) && Utils.enhancedDeepEquals(this.passkeys, other.passkeys) && Utils.enhancedDeepEquals(this.passwordEnabled, other.passwordEnabled) && Utils.enhancedDeepEquals(this.twoFactorEnabled, other.twoFactorEnabled) && Utils.enhancedDeepEquals(this.totpEnabled, other.totpEnabled) && Utils.enhancedDeepEquals(this.backupCodeEnabled, other.backupCodeEnabled) && Utils.enhancedDeepEquals(this.mfaEnabledAt, other.mfaEnabledAt) && Utils.enhancedDeepEquals(this.mfaDisabledAt, other.mfaDisabledAt) && Utils.enhancedDeepEquals(this.externalAccounts, other.externalAccounts) && Utils.enhancedDeepEquals(this.samlAccounts, other.samlAccounts) && Utils.enhancedDeepEquals(this.lastSignInAt, other.lastSignInAt) && Utils.enhancedDeepEquals(this.banned, other.banned) && Utils.enhancedDeepEquals(this.locked, other.locked) && Utils.enhancedDeepEquals(this.lockoutExpiresInSeconds, other.lockoutExpiresInSeconds) && Utils.enhancedDeepEquals(this.verificationAttemptsRemaining, other.verificationAttemptsRemaining) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.deleteSelfEnabled, other.deleteSelfEnabled) && Utils.enhancedDeepEquals(this.createOrganizationEnabled, other.createOrganizationEnabled) && Utils.enhancedDeepEquals(this.createOrganizationsLimit, other.createOrganizationsLimit) && Utils.enhancedDeepEquals(this.lastActiveAt, other.lastActiveAt) && Utils.enhancedDeepEquals(this.legalAcceptedAt, other.legalAcceptedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.id, this.object, this.externalId, this.primaryEmailAddressId, this.primaryPhoneNumberId, this.primaryWeb3WalletId, this.username, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.publicMetadata, this.privateMetadata, this.unsafeMetadata, this.emailAddresses, this.phoneNumbers, this.web3Wallets, this.passkeys, this.passwordEnabled, this.twoFactorEnabled, this.totpEnabled, this.backupCodeEnabled, this.mfaEnabledAt, this.mfaDisabledAt, this.externalAccounts, this.samlAccounts, this.lastSignInAt, this.banned, this.locked, this.lockoutExpiresInSeconds, this.verificationAttemptsRemaining, this.updatedAt, this.createdAt, this.deleteSelfEnabled, this.createOrganizationEnabled, this.createOrganizationsLimit, this.lastActiveAt, this.legalAcceptedAt});
    }

    public String toString() {
        return Utils.toString(User.class, new Object[]{"id", this.id, "object", this.object, "externalId", this.externalId, "primaryEmailAddressId", this.primaryEmailAddressId, "primaryPhoneNumberId", this.primaryPhoneNumberId, "primaryWeb3WalletId", this.primaryWeb3WalletId, "username", this.username, "firstName", this.firstName, "lastName", this.lastName, "profileImageUrl", this.profileImageUrl, "imageUrl", this.imageUrl, "hasImage", this.hasImage, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "unsafeMetadata", this.unsafeMetadata, "emailAddresses", this.emailAddresses, "phoneNumbers", this.phoneNumbers, "web3Wallets", this.web3Wallets, "passkeys", this.passkeys, "passwordEnabled", this.passwordEnabled, "twoFactorEnabled", this.twoFactorEnabled, "totpEnabled", this.totpEnabled, "backupCodeEnabled", this.backupCodeEnabled, "mfaEnabledAt", this.mfaEnabledAt, "mfaDisabledAt", this.mfaDisabledAt, "externalAccounts", this.externalAccounts, "samlAccounts", this.samlAccounts, "lastSignInAt", this.lastSignInAt, "banned", this.banned, "locked", this.locked, "lockoutExpiresInSeconds", this.lockoutExpiresInSeconds, "verificationAttemptsRemaining", this.verificationAttemptsRemaining, "updatedAt", this.updatedAt, "createdAt", this.createdAt, "deleteSelfEnabled", this.deleteSelfEnabled, "createOrganizationEnabled", this.createOrganizationEnabled, "createOrganizationsLimit", this.createOrganizationsLimit, "lastActiveAt", this.lastActiveAt, "legalAcceptedAt", this.legalAcceptedAt});
    }

    public static final class Builder {
        private String id;
        private UserObject object;
        private Optional<String> externalId = Optional.empty();
        private Optional<String> primaryEmailAddressId = Optional.empty();
        private Optional<String> primaryPhoneNumberId = Optional.empty();
        private Optional<String> primaryWeb3WalletId = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        @Deprecated
        private Optional<String> profileImageUrl = Optional.empty();
        private Optional<String> imageUrl = Optional.empty();
        private Boolean hasImage;
        private Map<String, Object> publicMetadata;
        private JsonNullable<? extends Map<String, Object>> privateMetadata = JsonNullable.undefined();
        private Optional<? extends Map<String, Object>> unsafeMetadata = Optional.empty();
        private List<EmailAddress> emailAddresses;
        private List<PhoneNumber> phoneNumbers;
        private List<Web3Wallet> web3Wallets;
        private List<Passkey> passkeys;
        private Boolean passwordEnabled;
        private Boolean twoFactorEnabled;
        private Boolean totpEnabled;
        private Boolean backupCodeEnabled;
        private Optional<Long> mfaEnabledAt = Optional.empty();
        private Optional<Long> mfaDisabledAt = Optional.empty();
        private List<ExternalAccountWithVerification> externalAccounts;
        private List<SAMLAccount> samlAccounts;
        private Optional<Long> lastSignInAt = Optional.empty();
        private Boolean banned;
        private Boolean locked;
        private Optional<Long> lockoutExpiresInSeconds = Optional.empty();
        private Optional<Long> verificationAttemptsRemaining = Optional.empty();
        private Long updatedAt;
        private Long createdAt;
        private Boolean deleteSelfEnabled;
        private Boolean createOrganizationEnabled;
        private JsonNullable<Long> createOrganizationsLimit = JsonNullable.undefined();
        private Optional<Long> lastActiveAt = Optional.empty();
        private Optional<Long> legalAcceptedAt = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(UserObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder externalId(String externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        public Builder externalId(Optional<String> externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = externalId;
            return this;
        }

        public Builder primaryEmailAddressId(String primaryEmailAddressId) {
            Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
            this.primaryEmailAddressId = Optional.ofNullable(primaryEmailAddressId);
            return this;
        }

        public Builder primaryEmailAddressId(Optional<String> primaryEmailAddressId) {
            Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
            this.primaryEmailAddressId = primaryEmailAddressId;
            return this;
        }

        public Builder primaryPhoneNumberId(String primaryPhoneNumberId) {
            Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
            this.primaryPhoneNumberId = Optional.ofNullable(primaryPhoneNumberId);
            return this;
        }

        public Builder primaryPhoneNumberId(Optional<String> primaryPhoneNumberId) {
            Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
            this.primaryPhoneNumberId = primaryPhoneNumberId;
            return this;
        }

        public Builder primaryWeb3WalletId(String primaryWeb3WalletId) {
            Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
            this.primaryWeb3WalletId = Optional.ofNullable(primaryWeb3WalletId);
            return this;
        }

        public Builder primaryWeb3WalletId(Optional<String> primaryWeb3WalletId) {
            Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
            this.primaryWeb3WalletId = primaryWeb3WalletId;
            return this;
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = Optional.ofNullable(username);
            return this;
        }

        public Builder username(Optional<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(String profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = Optional.ofNullable(profileImageUrl);
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(Optional<String> profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        public Builder imageUrl(Optional<String> imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder hasImage(boolean hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = hasImage;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = JsonNullable.of(privateMetadata);
            return this;
        }

        public Builder privateMetadata(JsonNullable<? extends Map<String, Object>> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder unsafeMetadata(Map<String, Object> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
            return this;
        }

        public Builder unsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = unsafeMetadata;
            return this;
        }

        public Builder emailAddresses(List<EmailAddress> emailAddresses) {
            Utils.checkNotNull(emailAddresses, "emailAddresses");
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumber> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder web3Wallets(List<Web3Wallet> web3Wallets) {
            Utils.checkNotNull(web3Wallets, "web3Wallets");
            this.web3Wallets = web3Wallets;
            return this;
        }

        public Builder passkeys(List<Passkey> passkeys) {
            Utils.checkNotNull(passkeys, "passkeys");
            this.passkeys = passkeys;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            Utils.checkNotNull(passwordEnabled, "passwordEnabled");
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder twoFactorEnabled(boolean twoFactorEnabled) {
            Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
            this.twoFactorEnabled = twoFactorEnabled;
            return this;
        }

        public Builder totpEnabled(boolean totpEnabled) {
            Utils.checkNotNull(totpEnabled, "totpEnabled");
            this.totpEnabled = totpEnabled;
            return this;
        }

        public Builder backupCodeEnabled(boolean backupCodeEnabled) {
            Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
            this.backupCodeEnabled = backupCodeEnabled;
            return this;
        }

        public Builder mfaEnabledAt(long mfaEnabledAt) {
            Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
            this.mfaEnabledAt = Optional.ofNullable(mfaEnabledAt);
            return this;
        }

        public Builder mfaEnabledAt(Optional<Long> mfaEnabledAt) {
            Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
            this.mfaEnabledAt = mfaEnabledAt;
            return this;
        }

        public Builder mfaDisabledAt(long mfaDisabledAt) {
            Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
            this.mfaDisabledAt = Optional.ofNullable(mfaDisabledAt);
            return this;
        }

        public Builder mfaDisabledAt(Optional<Long> mfaDisabledAt) {
            Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
            this.mfaDisabledAt = mfaDisabledAt;
            return this;
        }

        public Builder externalAccounts(List<ExternalAccountWithVerification> externalAccounts) {
            Utils.checkNotNull(externalAccounts, "externalAccounts");
            this.externalAccounts = externalAccounts;
            return this;
        }

        public Builder samlAccounts(List<SAMLAccount> samlAccounts) {
            Utils.checkNotNull(samlAccounts, "samlAccounts");
            this.samlAccounts = samlAccounts;
            return this;
        }

        public Builder lastSignInAt(long lastSignInAt) {
            Utils.checkNotNull(lastSignInAt, "lastSignInAt");
            this.lastSignInAt = Optional.ofNullable(lastSignInAt);
            return this;
        }

        public Builder lastSignInAt(Optional<Long> lastSignInAt) {
            Utils.checkNotNull(lastSignInAt, "lastSignInAt");
            this.lastSignInAt = lastSignInAt;
            return this;
        }

        public Builder banned(boolean banned) {
            Utils.checkNotNull(banned, "banned");
            this.banned = banned;
            return this;
        }

        public Builder locked(boolean locked) {
            Utils.checkNotNull(locked, "locked");
            this.locked = locked;
            return this;
        }

        public Builder lockoutExpiresInSeconds(long lockoutExpiresInSeconds) {
            Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
            this.lockoutExpiresInSeconds = Optional.ofNullable(lockoutExpiresInSeconds);
            return this;
        }

        public Builder lockoutExpiresInSeconds(Optional<Long> lockoutExpiresInSeconds) {
            Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
            this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
            return this;
        }

        public Builder verificationAttemptsRemaining(long verificationAttemptsRemaining) {
            Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
            this.verificationAttemptsRemaining = Optional.ofNullable(verificationAttemptsRemaining);
            return this;
        }

        public Builder verificationAttemptsRemaining(Optional<Long> verificationAttemptsRemaining) {
            Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
            this.verificationAttemptsRemaining = verificationAttemptsRemaining;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder deleteSelfEnabled(boolean deleteSelfEnabled) {
            Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
            this.deleteSelfEnabled = deleteSelfEnabled;
            return this;
        }

        public Builder createOrganizationEnabled(boolean createOrganizationEnabled) {
            Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
            this.createOrganizationEnabled = createOrganizationEnabled;
            return this;
        }

        public Builder createOrganizationsLimit(long createOrganizationsLimit) {
            Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
            this.createOrganizationsLimit = JsonNullable.of((Object)createOrganizationsLimit);
            return this;
        }

        public Builder createOrganizationsLimit(JsonNullable<Long> createOrganizationsLimit) {
            Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
            this.createOrganizationsLimit = createOrganizationsLimit;
            return this;
        }

        public Builder lastActiveAt(long lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = Optional.ofNullable(lastActiveAt);
            return this;
        }

        public Builder lastActiveAt(Optional<Long> lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        public Builder legalAcceptedAt(long legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = Optional.ofNullable(legalAcceptedAt);
            return this;
        }

        public Builder legalAcceptedAt(Optional<Long> legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = legalAcceptedAt;
            return this;
        }

        public User build() {
            return new User(this.id, this.object, this.externalId, this.primaryEmailAddressId, this.primaryPhoneNumberId, this.primaryWeb3WalletId, this.username, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.publicMetadata, this.privateMetadata, this.unsafeMetadata, this.emailAddresses, this.phoneNumbers, this.web3Wallets, this.passkeys, this.passwordEnabled, this.twoFactorEnabled, this.totpEnabled, this.backupCodeEnabled, this.mfaEnabledAt, this.mfaDisabledAt, this.externalAccounts, this.samlAccounts, this.lastSignInAt, this.banned, this.locked, this.lockoutExpiresInSeconds, this.verificationAttemptsRemaining, this.updatedAt, this.createdAt, this.deleteSelfEnabled, this.createOrganizationEnabled, this.createOrganizationsLimit, this.lastActiveAt, this.legalAcceptedAt);
        }
    }
}

