/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.PhoneNumberVerification;
import com.clerk.backend_api.models.components.VerificationOtpVerificationObject;
import com.clerk.backend_api.models.components.VerificationOtpVerificationStatus;
import com.clerk.backend_api.models.components.VerificationOtpVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class VerificationOTP
implements PhoneNumberVerification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationOtpVerificationObject> object;
    @JsonProperty(value="status")
    private VerificationOtpVerificationStatus status;
    @JsonProperty(value="strategy")
    private VerificationOtpVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public VerificationOTP(@JsonProperty(value="object") Optional<? extends VerificationOtpVerificationObject> object, @JsonProperty(value="status") VerificationOtpVerificationStatus status, @JsonProperty(value="strategy") VerificationOtpVerificationStrategy strategy, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.attempts = attempts;
        this.expireAt = expireAt;
        this.verifiedAtClient = verifiedAtClient;
    }

    public VerificationOTP(VerificationOtpVerificationStatus status, VerificationOtpVerificationStrategy strategy) {
        this(Optional.empty(), status, strategy, Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationOtpVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public VerificationOtpVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerificationOTP withObject(VerificationOtpVerificationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public VerificationOTP withObject(Optional<? extends VerificationOtpVerificationObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public VerificationOTP withStatus(VerificationOtpVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public VerificationOTP withStrategy(VerificationOtpVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public VerificationOTP withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public VerificationOTP withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public VerificationOTP withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public VerificationOTP withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public VerificationOTP withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public VerificationOTP withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationOTP other = (VerificationOTP)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.strategy, other.strategy) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(VerificationOTP.class, new Object[]{"object", this.object, "status", this.status, "strategy", this.strategy, "attempts", this.attempts, "expireAt", this.expireAt, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Optional<? extends VerificationOtpVerificationObject> object = Optional.empty();
        private VerificationOtpVerificationStatus status;
        private VerificationOtpVerificationStrategy strategy;
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationOtpVerificationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationOtpVerificationObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationOtpVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(VerificationOtpVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public VerificationOTP build() {
            return new VerificationOTP(this.object, this.status, this.strategy, this.attempts, this.expireAt, this.verifiedAtClient);
        }
    }
}

