/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class VerificationOtpVerificationStrategy {
    public static final VerificationOtpVerificationStrategy PHONE_CODE = new VerificationOtpVerificationStrategy("phone_code");
    public static final VerificationOtpVerificationStrategy EMAIL_CODE = new VerificationOtpVerificationStrategy("email_code");
    public static final VerificationOtpVerificationStrategy RESET_PASSWORD_EMAIL_CODE = new VerificationOtpVerificationStrategy("reset_password_email_code");
    private static final Map<String, VerificationOtpVerificationStrategy> values = VerificationOtpVerificationStrategy.createValuesMap();
    private static final Map<String, VerificationOtpVerificationStrategyEnum> enums = VerificationOtpVerificationStrategy.createEnumsMap();
    private final String value;

    private VerificationOtpVerificationStrategy(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerificationOtpVerificationStrategy of(String value) {
        Class<VerificationOtpVerificationStrategy> clazz = VerificationOtpVerificationStrategy.class;
        synchronized (VerificationOtpVerificationStrategy.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new VerificationOtpVerificationStrategy((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<VerificationOtpVerificationStrategyEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerificationOtpVerificationStrategy other = (VerificationOtpVerificationStrategy)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "VerificationOtpVerificationStrategy [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerificationOtpVerificationStrategy[] values() {
        Class<VerificationOtpVerificationStrategy> clazz = VerificationOtpVerificationStrategy.class;
        synchronized (VerificationOtpVerificationStrategy.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new VerificationOtpVerificationStrategy[0]);
        }
    }

    private static final Map<String, VerificationOtpVerificationStrategy> createValuesMap() {
        LinkedHashMap<String, VerificationOtpVerificationStrategy> map = new LinkedHashMap<String, VerificationOtpVerificationStrategy>();
        map.put("phone_code", PHONE_CODE);
        map.put("email_code", EMAIL_CODE);
        map.put("reset_password_email_code", RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    private static final Map<String, VerificationOtpVerificationStrategyEnum> createEnumsMap() {
        HashMap<String, VerificationOtpVerificationStrategyEnum> map = new HashMap<String, VerificationOtpVerificationStrategyEnum>();
        map.put("phone_code", VerificationOtpVerificationStrategyEnum.PHONE_CODE);
        map.put("email_code", VerificationOtpVerificationStrategyEnum.EMAIL_CODE);
        map.put("reset_password_email_code", VerificationOtpVerificationStrategyEnum.RESET_PASSWORD_EMAIL_CODE);
        return map;
    }

    public static enum VerificationOtpVerificationStrategyEnum {
        PHONE_CODE("phone_code"),
        EMAIL_CODE("email_code"),
        RESET_PASSWORD_EMAIL_CODE("reset_password_email_code");

        private final String value;

        private VerificationOtpVerificationStrategyEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<VerificationOtpVerificationStrategy> {
        protected _Deserializer() {
            super(VerificationOtpVerificationStrategy.class);
        }

        public VerificationOtpVerificationStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return VerificationOtpVerificationStrategy.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<VerificationOtpVerificationStrategy> {
        protected _Serializer() {
            super(VerificationOtpVerificationStrategy.class);
        }

        public void serialize(VerificationOtpVerificationStrategy value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

