/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SAMLAccountVerification;
import com.clerk.backend_api.models.components.VerificationSAMLVerificationSAMLAccountObject;
import com.clerk.backend_api.models.components.VerificationSAMLVerificationSAMLAccountStatus;
import com.clerk.backend_api.models.components.VerificationSAMLVerificationSAMLAccountStrategy;
import com.clerk.backend_api.models.components.VerificationSamlVerificationError;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class VerificationSAML
implements SAMLAccountVerification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationSAMLVerificationSAMLAccountObject> object;
    @JsonProperty(value="status")
    private VerificationSAMLVerificationSAMLAccountStatus status;
    @JsonProperty(value="strategy")
    private VerificationSAMLVerificationSAMLAccountStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_verification_redirect_url")
    private JsonNullable<String> externalVerificationRedirectUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends VerificationSamlVerificationError> error;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expire_at")
    private JsonNullable<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public VerificationSAML(@JsonProperty(value="object") Optional<? extends VerificationSAMLVerificationSAMLAccountObject> object, @JsonProperty(value="status") VerificationSAMLVerificationSAMLAccountStatus status, @JsonProperty(value="strategy") VerificationSAMLVerificationSAMLAccountStrategy strategy, @JsonProperty(value="external_verification_redirect_url") JsonNullable<String> externalVerificationRedirectUrl, @JsonProperty(value="error") JsonNullable<? extends VerificationSamlVerificationError> error, @JsonProperty(value="expire_at") JsonNullable<Long> expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        this.error = error;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
    }

    public VerificationSAML(VerificationSAMLVerificationSAMLAccountStatus status, VerificationSAMLVerificationSAMLAccountStrategy strategy) {
        this(Optional.empty(), status, strategy, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends VerificationSamlVerificationError>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationSAMLVerificationSAMLAccountStatus status() {
        return this.status;
    }

    @JsonIgnore
    public VerificationSAMLVerificationSAMLAccountStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public JsonNullable<String> externalVerificationRedirectUrl() {
        return this.externalVerificationRedirectUrl;
    }

    @JsonIgnore
    public JsonNullable<VerificationSamlVerificationError> error() {
        return this.error;
    }

    @JsonIgnore
    public JsonNullable<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerificationSAML withObject(VerificationSAMLVerificationSAMLAccountObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public VerificationSAML withObject(Optional<? extends VerificationSAMLVerificationSAMLAccountObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public VerificationSAML withStatus(VerificationSAMLVerificationSAMLAccountStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public VerificationSAML withStrategy(VerificationSAMLVerificationSAMLAccountStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public VerificationSAML withExternalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = JsonNullable.of((Object)externalVerificationRedirectUrl);
        return this;
    }

    public VerificationSAML withExternalVerificationRedirectUrl(JsonNullable<String> externalVerificationRedirectUrl) {
        Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
        this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
        return this;
    }

    public VerificationSAML withError(VerificationSamlVerificationError error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public VerificationSAML withError(JsonNullable<? extends VerificationSamlVerificationError> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public VerificationSAML withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = JsonNullable.of((Object)expireAt);
        return this;
    }

    public VerificationSAML withExpireAt(JsonNullable<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public VerificationSAML withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public VerificationSAML withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public VerificationSAML withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public VerificationSAML withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationSAML other = (VerificationSAML)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals((Object)this.strategy, (Object)other.strategy) && Utils.enhancedDeepEquals(this.externalVerificationRedirectUrl, other.externalVerificationRedirectUrl) && Utils.enhancedDeepEquals(this.error, other.error) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(VerificationSAML.class, new Object[]{"object", this.object, "status", this.status, "strategy", this.strategy, "externalVerificationRedirectUrl", this.externalVerificationRedirectUrl, "error", this.error, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Optional<? extends VerificationSAMLVerificationSAMLAccountObject> object = Optional.empty();
        private VerificationSAMLVerificationSAMLAccountStatus status;
        private VerificationSAMLVerificationSAMLAccountStrategy strategy;
        private JsonNullable<String> externalVerificationRedirectUrl = JsonNullable.undefined();
        private JsonNullable<? extends VerificationSamlVerificationError> error = JsonNullable.undefined();
        private JsonNullable<Long> expireAt = JsonNullable.undefined();
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationSAMLVerificationSAMLAccountObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationSAMLVerificationSAMLAccountObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationSAMLVerificationSAMLAccountStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(VerificationSAMLVerificationSAMLAccountStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder externalVerificationRedirectUrl(String externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = JsonNullable.of((Object)externalVerificationRedirectUrl);
            return this;
        }

        public Builder externalVerificationRedirectUrl(JsonNullable<String> externalVerificationRedirectUrl) {
            Utils.checkNotNull(externalVerificationRedirectUrl, "externalVerificationRedirectUrl");
            this.externalVerificationRedirectUrl = externalVerificationRedirectUrl;
            return this;
        }

        public Builder error(VerificationSamlVerificationError error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends VerificationSamlVerificationError> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = JsonNullable.of((Object)expireAt);
            return this;
        }

        public Builder expireAt(JsonNullable<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public VerificationSAML build() {
            return new VerificationSAML(this.object, this.status, this.strategy, this.externalVerificationRedirectUrl, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
        }
    }
}

