/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ClerkErrorErrorMeta;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class VerificationSamlErrorClerkError {
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="long_message")
    private String longMessage;
    @JsonProperty(value="code")
    private String code;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="meta")
    private Optional<? extends ClerkErrorErrorMeta> meta;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clerk_trace_id")
    private Optional<String> clerkTraceId;

    @JsonCreator
    public VerificationSamlErrorClerkError(@JsonProperty(value="message") String message, @JsonProperty(value="long_message") String longMessage, @JsonProperty(value="code") String code, @JsonProperty(value="meta") Optional<? extends ClerkErrorErrorMeta> meta, @JsonProperty(value="clerk_trace_id") Optional<String> clerkTraceId) {
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(longMessage, "longMessage");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(meta, "meta");
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.message = message;
        this.longMessage = longMessage;
        this.code = code;
        this.meta = meta;
        this.clerkTraceId = clerkTraceId;
    }

    public VerificationSamlErrorClerkError(String message, String longMessage, String code) {
        this(message, longMessage, code, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String message() {
        return this.message;
    }

    @JsonIgnore
    public String longMessage() {
        return this.longMessage;
    }

    @JsonIgnore
    public String code() {
        return this.code;
    }

    @JsonIgnore
    public Optional<ClerkErrorErrorMeta> meta() {
        return this.meta;
    }

    @JsonIgnore
    public Optional<String> clerkTraceId() {
        return this.clerkTraceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerificationSamlErrorClerkError withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public VerificationSamlErrorClerkError withLongMessage(String longMessage) {
        Utils.checkNotNull(longMessage, "longMessage");
        this.longMessage = longMessage;
        return this;
    }

    public VerificationSamlErrorClerkError withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public VerificationSamlErrorClerkError withMeta(ClerkErrorErrorMeta meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = Optional.ofNullable(meta);
        return this;
    }

    public VerificationSamlErrorClerkError withMeta(Optional<? extends ClerkErrorErrorMeta> meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = meta;
        return this;
    }

    public VerificationSamlErrorClerkError withClerkTraceId(String clerkTraceId) {
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.clerkTraceId = Optional.ofNullable(clerkTraceId);
        return this;
    }

    public VerificationSamlErrorClerkError withClerkTraceId(Optional<String> clerkTraceId) {
        Utils.checkNotNull(clerkTraceId, "clerkTraceId");
        this.clerkTraceId = clerkTraceId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationSamlErrorClerkError other = (VerificationSamlErrorClerkError)o;
        return Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.longMessage, other.longMessage) && Utils.enhancedDeepEquals(this.code, other.code) && Utils.enhancedDeepEquals(this.meta, other.meta) && Utils.enhancedDeepEquals(this.clerkTraceId, other.clerkTraceId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.message, this.longMessage, this.code, this.meta, this.clerkTraceId);
    }

    public String toString() {
        return Utils.toString(VerificationSamlErrorClerkError.class, "message", this.message, "longMessage", this.longMessage, "code", this.code, "meta", this.meta, "clerkTraceId", this.clerkTraceId);
    }

    public static final class Builder {
        private String message;
        private String longMessage;
        private String code;
        private Optional<? extends ClerkErrorErrorMeta> meta = Optional.empty();
        private Optional<String> clerkTraceId = Optional.empty();

        private Builder() {
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder longMessage(String longMessage) {
            Utils.checkNotNull(longMessage, "longMessage");
            this.longMessage = longMessage;
            return this;
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder meta(ClerkErrorErrorMeta meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        public Builder meta(Optional<? extends ClerkErrorErrorMeta> meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = meta;
            return this;
        }

        public Builder clerkTraceId(String clerkTraceId) {
            Utils.checkNotNull(clerkTraceId, "clerkTraceId");
            this.clerkTraceId = Optional.ofNullable(clerkTraceId);
            return this;
        }

        public Builder clerkTraceId(Optional<String> clerkTraceId) {
            Utils.checkNotNull(clerkTraceId, "clerkTraceId");
            this.clerkTraceId = clerkTraceId;
            return this;
        }

        public VerificationSamlErrorClerkError build() {
            return new VerificationSamlErrorClerkError(this.message, this.longMessage, this.code, this.meta, this.clerkTraceId);
        }
    }
}

