/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.WaitlistEntry;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class WaitlistEntries {
    @JsonProperty(value="data")
    private List<WaitlistEntry> data;
    @JsonProperty(value="total_count")
    private long totalCount;

    @JsonCreator
    public WaitlistEntries(@JsonProperty(value="data") List<WaitlistEntry> data, @JsonProperty(value="total_count") long totalCount) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(totalCount, "totalCount");
        this.data = data;
        this.totalCount = totalCount;
    }

    @JsonIgnore
    public List<WaitlistEntry> data() {
        return this.data;
    }

    @JsonIgnore
    public long totalCount() {
        return this.totalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public WaitlistEntries withData(List<WaitlistEntry> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public WaitlistEntries withTotalCount(long totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitlistEntries other = (WaitlistEntries)o;
        return Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.totalCount, other.totalCount);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.data, this.totalCount);
    }

    public String toString() {
        return Utils.toString(WaitlistEntries.class, "data", this.data, "totalCount", this.totalCount);
    }

    public static final class Builder {
        private List<WaitlistEntry> data;
        private Long totalCount;

        private Builder() {
        }

        public Builder data(List<WaitlistEntry> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder totalCount(long totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public WaitlistEntries build() {
            return new WaitlistEntries(this.data, this.totalCount);
        }
    }
}

