/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.WaitlistEntryInvitation;
import com.clerk.backend_api.models.components.WaitlistEntryObject;
import com.clerk.backend_api.models.components.WaitlistEntryStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class WaitlistEntry {
    @JsonProperty(value="object")
    private WaitlistEntryObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonProperty(value="status")
    private WaitlistEntryStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="is_locked")
    private Optional<Boolean> isLocked;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="invitation")
    private JsonNullable<? extends WaitlistEntryInvitation> invitation;

    @JsonCreator
    public WaitlistEntry(@JsonProperty(value="object") WaitlistEntryObject object, @JsonProperty(value="id") String id, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="status") WaitlistEntryStatus status, @JsonProperty(value="is_locked") Optional<Boolean> isLocked, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="invitation") JsonNullable<? extends WaitlistEntryInvitation> invitation) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(isLocked, "isLocked");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(invitation, "invitation");
        this.object = object;
        this.id = id;
        this.emailAddress = emailAddress;
        this.status = status;
        this.isLocked = isLocked;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.invitation = invitation;
    }

    public WaitlistEntry(WaitlistEntryObject object, String id, String emailAddress, WaitlistEntryStatus status, long createdAt, long updatedAt) {
        this(object, id, emailAddress, status, Optional.empty(), createdAt, updatedAt, (JsonNullable<? extends WaitlistEntryInvitation>)JsonNullable.undefined());
    }

    @JsonIgnore
    public WaitlistEntryObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public WaitlistEntryStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<Boolean> isLocked() {
        return this.isLocked;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public JsonNullable<WaitlistEntryInvitation> invitation() {
        return this.invitation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public WaitlistEntry withObject(WaitlistEntryObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public WaitlistEntry withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public WaitlistEntry withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public WaitlistEntry withStatus(WaitlistEntryStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public WaitlistEntry withIsLocked(boolean isLocked) {
        Utils.checkNotNull(isLocked, "isLocked");
        this.isLocked = Optional.ofNullable(isLocked);
        return this;
    }

    public WaitlistEntry withIsLocked(Optional<Boolean> isLocked) {
        Utils.checkNotNull(isLocked, "isLocked");
        this.isLocked = isLocked;
        return this;
    }

    public WaitlistEntry withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public WaitlistEntry withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public WaitlistEntry withInvitation(WaitlistEntryInvitation invitation) {
        Utils.checkNotNull(invitation, "invitation");
        this.invitation = JsonNullable.of((Object)invitation);
        return this;
    }

    public WaitlistEntry withInvitation(JsonNullable<? extends WaitlistEntryInvitation> invitation) {
        Utils.checkNotNull(invitation, "invitation");
        this.invitation = invitation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitlistEntry other = (WaitlistEntry)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.isLocked, other.isLocked) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) && Utils.enhancedDeepEquals(this.invitation, other.invitation);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.emailAddress, this.status, this.isLocked, this.createdAt, this.updatedAt, this.invitation});
    }

    public String toString() {
        return Utils.toString(WaitlistEntry.class, new Object[]{"object", this.object, "id", this.id, "emailAddress", this.emailAddress, "status", this.status, "isLocked", this.isLocked, "createdAt", this.createdAt, "updatedAt", this.updatedAt, "invitation", this.invitation});
    }

    public static final class Builder {
        private WaitlistEntryObject object;
        private String id;
        private String emailAddress;
        private WaitlistEntryStatus status;
        private Optional<Boolean> isLocked = Optional.empty();
        private Long createdAt;
        private Long updatedAt;
        private JsonNullable<? extends WaitlistEntryInvitation> invitation = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(WaitlistEntryObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder status(WaitlistEntryStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder isLocked(boolean isLocked) {
            Utils.checkNotNull(isLocked, "isLocked");
            this.isLocked = Optional.ofNullable(isLocked);
            return this;
        }

        public Builder isLocked(Optional<Boolean> isLocked) {
            Utils.checkNotNull(isLocked, "isLocked");
            this.isLocked = isLocked;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder invitation(WaitlistEntryInvitation invitation) {
            Utils.checkNotNull(invitation, "invitation");
            this.invitation = JsonNullable.of((Object)invitation);
            return this;
        }

        public Builder invitation(JsonNullable<? extends WaitlistEntryInvitation> invitation) {
            Utils.checkNotNull(invitation, "invitation");
            this.invitation = invitation;
            return this;
        }

        public WaitlistEntry build() {
            return new WaitlistEntry(this.object, this.id, this.emailAddress, this.status, this.isLocked, this.createdAt, this.updatedAt, this.invitation);
        }
    }
}

