/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.VerificationWeb3VerificationObject;
import com.clerk.backend_api.models.components.VerificationWeb3VerificationStatus;
import com.clerk.backend_api.models.components.VerificationWeb3VerificationStrategy;
import com.clerk.backend_api.models.components.Web3WalletVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Web3Signature
implements Web3WalletVerification {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends VerificationWeb3VerificationObject> object;
    @JsonProperty(value="status")
    private VerificationWeb3VerificationStatus status;
    @JsonProperty(value="strategy")
    private VerificationWeb3VerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="nonce")
    private JsonNullable<String> nonce;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="message")
    private JsonNullable<String> message;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Web3Signature(@JsonProperty(value="object") Optional<? extends VerificationWeb3VerificationObject> object, @JsonProperty(value="status") VerificationWeb3VerificationStatus status, @JsonProperty(value="strategy") VerificationWeb3VerificationStrategy strategy, @JsonProperty(value="nonce") JsonNullable<String> nonce, @JsonProperty(value="message") JsonNullable<String> message, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(nonce, "nonce");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.object = object;
        this.status = status;
        this.strategy = strategy;
        this.nonce = nonce;
        this.message = message;
        this.attempts = attempts;
        this.expireAt = expireAt;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Web3Signature(VerificationWeb3VerificationStatus status, VerificationWeb3VerificationStrategy strategy) {
        this(Optional.empty(), status, strategy, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @Override
    @JsonIgnore
    public String object() {
        return Utils.discriminatorToString(this.object);
    }

    @JsonIgnore
    public VerificationWeb3VerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public VerificationWeb3VerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public JsonNullable<String> nonce() {
        return this.nonce;
    }

    @JsonIgnore
    public JsonNullable<String> message() {
        return this.message;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Web3Signature withObject(VerificationWeb3VerificationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public Web3Signature withObject(Optional<? extends VerificationWeb3VerificationObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Web3Signature withStatus(VerificationWeb3VerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Web3Signature withStrategy(VerificationWeb3VerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Web3Signature withNonce(String nonce) {
        Utils.checkNotNull(nonce, "nonce");
        this.nonce = JsonNullable.of((Object)nonce);
        return this;
    }

    public Web3Signature withNonce(JsonNullable<String> nonce) {
        Utils.checkNotNull(nonce, "nonce");
        this.nonce = nonce;
        return this;
    }

    public Web3Signature withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of((Object)message);
        return this;
    }

    public Web3Signature withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public Web3Signature withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Web3Signature withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Web3Signature withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public Web3Signature withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Web3Signature withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Web3Signature withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Web3Signature other = (Web3Signature)o;
        return Utils.enhancedDeepEquals(this.object, other.object) && Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals((Object)this.strategy, (Object)other.strategy) && Utils.enhancedDeepEquals(this.nonce, other.nonce) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.attempts, other.attempts) && Utils.enhancedDeepEquals(this.expireAt, other.expireAt) && Utils.enhancedDeepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.status, this.strategy, this.nonce, this.message, this.attempts, this.expireAt, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(Web3Signature.class, new Object[]{"object", this.object, "status", this.status, "strategy", this.strategy, "nonce", this.nonce, "message", this.message, "attempts", this.attempts, "expireAt", this.expireAt, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Optional<? extends VerificationWeb3VerificationObject> object = Optional.empty();
        private VerificationWeb3VerificationStatus status;
        private VerificationWeb3VerificationStrategy strategy;
        private JsonNullable<String> nonce = JsonNullable.undefined();
        private JsonNullable<String> message = JsonNullable.undefined();
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder object(VerificationWeb3VerificationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends VerificationWeb3VerificationObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder status(VerificationWeb3VerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(VerificationWeb3VerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder nonce(String nonce) {
            Utils.checkNotNull(nonce, "nonce");
            this.nonce = JsonNullable.of((Object)nonce);
            return this;
        }

        public Builder nonce(JsonNullable<String> nonce) {
            Utils.checkNotNull(nonce, "nonce");
            this.nonce = nonce;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of((Object)message);
            return this;
        }

        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Web3Signature build() {
            return new Web3Signature(this.object, this.status, this.strategy, this.nonce, this.message, this.attempts, this.expireAt, this.verifiedAtClient);
        }
    }
}

