/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.errors;

import com.clerk.backend_api.models.errors.GetM2MTokensErrors;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;

public class GetM2MTokensResponseBody
extends RuntimeException {
    @JsonProperty(value="errors")
    private List<GetM2MTokensErrors> errors;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="RawResponse")
    private Optional<? extends HttpResponse<InputStream>> rawResponse;

    @JsonCreator
    public GetM2MTokensResponseBody(@JsonProperty(value="errors") List<GetM2MTokensErrors> errors, @JsonProperty(value="RawResponse") Optional<? extends HttpResponse<InputStream>> rawResponse) {
        super("API error occurred");
        Utils.checkNotNull(errors, "errors");
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.errors = errors;
        this.rawResponse = rawResponse;
    }

    public GetM2MTokensResponseBody(List<GetM2MTokensErrors> errors) {
        this(errors, Optional.empty());
    }

    @JsonIgnore
    public List<GetM2MTokensErrors> errors() {
        return this.errors;
    }

    @JsonIgnore
    public Optional<HttpResponse<InputStream>> rawResponse() {
        return this.rawResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetM2MTokensResponseBody withErrors(List<GetM2MTokensErrors> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = errors;
        return this;
    }

    public GetM2MTokensResponseBody withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = Optional.ofNullable(rawResponse);
        return this;
    }

    public GetM2MTokensResponseBody withRawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetM2MTokensResponseBody other = (GetM2MTokensResponseBody)o;
        return Utils.enhancedDeepEquals(this.errors, other.errors) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.errors, this.rawResponse);
    }

    @Override
    public String toString() {
        return Utils.toString(GetM2MTokensResponseBody.class, "errors", this.errors, "rawResponse", this.rawResponse);
    }

    public static final class Builder {
        private List<GetM2MTokensErrors> errors;
        private Optional<? extends HttpResponse<InputStream>> rawResponse;

        private Builder() {
        }

        public Builder errors(List<GetM2MTokensErrors> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = errors;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = Optional.ofNullable(rawResponse);
            return this;
        }

        public Builder rawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public GetM2MTokensResponseBody build() {
            return new GetM2MTokensResponseBody(this.errors, this.rawResponse);
        }
    }
}

